/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class Ip4PrefixTest {
    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutable(Ip4Prefix.class);
    }

    @Test
    public void testAddressVersion() {
        Assert.assertThat((Object)Ip4Prefix.VERSION, (Matcher)Matchers.is((Object)IpAddress.Version.INET));
    }

    @Test
    public void testMaxMaskLength() {
        Assert.assertThat((Object)32, (Matcher)Matchers.is((Object)32));
    }

    @Test
    public void testVersion() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.version(), (Matcher)Matchers.is((Object)IpAddress.Version.INET));
    }

    @Test
    public void testAddressAndPrefixLengthIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"1.2.3.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)24));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"1.2.3.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)24));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"1.2.3.4")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.5/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"1.2.3.5")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"0.0.0.0")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)0));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.address(), (Matcher)Matchers.equalTo((Object)Ip4Address.valueOf((String)"255.255.255.255")));
        Assert.assertThat((Object)ipPrefix.prefixLength(), (Matcher)Matchers.is((Object)32));
    }

    @Test
    public void testValueOfForIntegerIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((int)16909060, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((int)16909060, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipPrefix = Ip4Prefix.valueOf((int)16909061, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipPrefix = Ip4Prefix.valueOf((int)0, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((int)0, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipPrefix = Ip4Prefix.valueOf((int)-1, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((int)-1, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = Ip4Prefix.valueOf((int)-1, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIntegerNegativePrefixLengthIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((int)16909060, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIntegerTooLongPrefixLengthIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((int)16909060, (int)33);
    }

    @Test
    public void testValueOfByteArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        value = new byte[]{1, 2, 3, 5};
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        value = new byte[]{0, 0, 0, 0};
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        value = new byte[]{-1, -1, -1, -1};
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullArrayIPv4() {
        byte[] value = null;
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf(value, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfShortArrayIPv4() {
        byte[] value = new byte[]{1, 2, 3};
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayNegativePrefixLengthIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfByteArrayTooLongPrefixLengthIPv4() {
        byte[] value = new byte[]{1, 2, 3, 4};
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((byte[])value, (int)33);
    }

    @Test
    public void testValueOfAddressIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)24);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipAddress = Ip4Address.valueOf((String)"1.2.3.5");
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipAddress = Ip4Address.valueOf((String)"0.0.0.0");
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipAddress = Ip4Address.valueOf((String)"255.255.255.255");
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)0);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)16);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)32);
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullAddress() {
        Ip4Address ipAddress = null;
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf(ipAddress, (int)24);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressNegativePrefixLengthIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfAddressTooLongPrefixLengthIPv4() {
        Ip4Address ipAddress = Ip4Address.valueOf((String)"1.2.3.4");
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((Ip4Address)ipAddress, (int)33);
    }

    @Test
    public void testValueOfStringIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.4/32"));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.5/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.5/32"));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/32"));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/16");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.0.0/16"));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }

    @Test(expected=NullPointerException.class)
    public void testInvalidValueOfNullString() {
        String fromString = null;
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf(fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfEmptyString() {
        String fromString = "";
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfIncorrectString() {
        String fromString = "NoSuchIpPrefix";
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)fromString);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringNegativePrefixLengthIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/-1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidValueOfStringTooLongPrefixLengthIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/33");
    }

    @Test
    public void testContainsIpPrefixIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.0.0/24");
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.0.0/32");
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"255.255.255.255/32")));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/32")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.4/32")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.2.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"1.3.0.0/24")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/16")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"0.0.0.0/0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpPrefix)Ip4Prefix.valueOf((String)"255.255.255.255/32")));
    }

    @Test
    public void testContainsIpAddressIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.0.0/24");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"0.0.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"255.255.255.255")));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.0.0/32");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"0.0.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"255.255.255.255")));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.4")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.3.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"0.0.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"255.255.255.255")));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/32");
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.2.0.4")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"1.3.0.0")));
        Assert.assertFalse((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"0.0.0.0")));
        Assert.assertTrue((boolean)ipPrefix.contains((IpAddress)Ip4Address.valueOf((String)"255.255.255.255")));
    }

    @Test
    public void testEqualityIPv4() {
        new EqualsTester().addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"1.2.0.0/24"), Ip4Prefix.valueOf((String)"1.2.0.0/24"), Ip4Prefix.valueOf((String)"1.2.0.4/24")}).addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"1.2.0.0/16"), Ip4Prefix.valueOf((String)"1.2.0.0/16")}).addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"1.2.0.0/32"), Ip4Prefix.valueOf((String)"1.2.0.0/32")}).addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"1.3.0.0/24"), Ip4Prefix.valueOf((String)"1.3.0.0/24")}).addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"0.0.0.0/0"), Ip4Prefix.valueOf((String)"0.0.0.0/0")}).addEqualityGroup(new Object[]{Ip4Prefix.valueOf((String)"255.255.255.255/32"), Ip4Prefix.valueOf((String)"255.255.255.255/32")}).testEquals();
    }

    @Test
    public void testToStringIPv4() {
        Ip4Prefix ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.0/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((String)"1.2.3.4/24");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"1.2.3.0/24"));
        ipPrefix = Ip4Prefix.valueOf((String)"0.0.0.0/0");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"0.0.0.0/0"));
        ipPrefix = Ip4Prefix.valueOf((String)"255.255.255.255/32");
        Assert.assertThat((Object)ipPrefix.toString(), (Matcher)Matchers.is((Object)"255.255.255.255/32"));
    }
}

