/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ndp;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.VlanId;
import org.onlab.packet.ndp.NeighborDiscoveryOptions;
import org.onlab.packet.ndp.NeighborSolicitation;

public class NeighborSolicitationTest {
    private static final Ip6Address TARGET_IP = Ip6Address.valueOf((String)"2000::1");
    private static final Ip6Address SRC_IP = Ip6Address.valueOf((String)"2000::f");
    private static final Ip6Address DST_IP = Ip6Address.valueOf((String)"2000::1");
    private static final MacAddress SRC_MAC = MacAddress.valueOf((String)"00:00:00:00:00:0f");
    private static final MacAddress DST_MAC = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final VlanId VLAN_ID = VlanId.NONE;
    private static final byte[] TARGET_ADDRESS = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    private static final byte[] TARGET_ADDRESS2 = new byte[]{32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"11:22:33:44:55:66");
    private static byte[] bytePacket;
    private Deserializer<NeighborSolicitation> deserializer = NeighborSolicitation.deserializer();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        byte[] byteHeader = new byte[]{0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 2, 1, 17, 34, 51, 68, 85, 102};
        bytePacket = new byte[byteHeader.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
    }

    @Test
    public void testSerialize() {
        NeighborSolicitation ns = new NeighborSolicitation();
        ns.setTargetAddress(TARGET_ADDRESS);
        ns.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertArrayEquals((byte[])ns.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(NeighborSolicitation.deserializer());
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        byte[] nsHeader = new byte[20];
        ByteBuffer.wrap(bytePacket).get(nsHeader);
        PacketTestUtils.testDeserializeTruncated(NeighborSolicitation.deserializer(), nsHeader);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        NeighborSolicitation ns = (NeighborSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertArrayEquals((byte[])ns.getTargetAddress(), (byte[])TARGET_ADDRESS);
        Assert.assertThat((Object)ns.getOptions().size(), (Matcher)Matchers.is((Object)1));
        NeighborDiscoveryOptions.Option option = (NeighborDiscoveryOptions.Option)ns.getOptions().get(0);
        Assert.assertThat((Object)option.type(), (Matcher)Matchers.is((Object)2));
        Assert.assertArrayEquals((byte[])option.data(), (byte[])MAC_ADDRESS.toBytes());
    }

    @Test
    public void testEqual() {
        NeighborSolicitation ns1 = new NeighborSolicitation();
        ns1.setTargetAddress(TARGET_ADDRESS);
        ns1.addOption((byte)2, MAC_ADDRESS.toBytes());
        NeighborSolicitation ns2 = new NeighborSolicitation();
        ns2.setTargetAddress(TARGET_ADDRESS2);
        ns2.addOption((byte)2, MAC_ADDRESS.toBytes());
        Assert.assertTrue((boolean)ns1.equals((Object)ns1));
        Assert.assertFalse((boolean)ns1.equals((Object)ns2));
    }

    @Test
    public void testToStringNS() throws Exception {
        NeighborSolicitation ns = (NeighborSolicitation)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = ns.toString();
    }

    @Test
    public void testBuildNdpSolicit() throws Exception {
        Ethernet ethPacket = NeighborSolicitation.buildNdpSolicit((Ip6Address)TARGET_IP, (Ip6Address)SRC_IP, (Ip6Address)DST_IP, (MacAddress)SRC_MAC, (MacAddress)DST_MAC, (VlanId)VLAN_ID);
        Assert.assertTrue((boolean)ethPacket.getDestinationMAC().equals((Object)DST_MAC));
        Assert.assertTrue((boolean)ethPacket.getSourceMAC().equals((Object)SRC_MAC));
        Assert.assertTrue((ethPacket.getEtherType() == Ethernet.TYPE_IPV6 ? 1 : 0) != 0);
        Assert.assertTrue((ethPacket.getVlanID() == ((Short)VLAN_ID.id()).shortValue() ? 1 : 0) != 0);
        IPv6 ipPacket = (IPv6)ethPacket.getPayload();
        Assert.assertArrayEquals((byte[])ipPacket.getSourceAddress(), (byte[])SRC_IP.toOctets());
        Assert.assertArrayEquals((byte[])ipPacket.getDestinationAddress(), (byte[])DST_IP.toOctets());
        ICMP6 icmp6Packet = (ICMP6)ipPacket.getPayload();
        NeighborSolicitation nsPacket = (NeighborSolicitation)icmp6Packet.getPayload();
        Assert.assertArrayEquals((byte[])nsPacket.getTargetAddress(), (byte[])TARGET_IP.toOctets());
        Assert.assertEquals((String)"Non-DAD NS should have 1 option", (long)1L, (long)nsPacket.getOptions().size());
        Assert.assertEquals((String)"The option should be SRC_LL_ADDR type", (long)1L, (long)((NeighborDiscoveryOptions.Option)nsPacket.getOptions().stream().findFirst().get()).type());
    }

    @Test
    public void testBuildNdpSolicitDad() throws Exception {
        Ethernet ethPacket = NeighborSolicitation.buildNdpSolicit((Ip6Address)TARGET_IP, (Ip6Address)Ip6Address.ZERO, (Ip6Address)DST_IP, (MacAddress)SRC_MAC, (MacAddress)DST_MAC, (VlanId)VLAN_ID);
        IPv6 ipPacket = (IPv6)ethPacket.getPayload();
        ICMP6 icmp6Packet = (ICMP6)ipPacket.getPayload();
        NeighborSolicitation nsPacket = (NeighborSolicitation)icmp6Packet.getPayload();
        Assert.assertEquals((String)"DAD NS should have no option", (long)0L, (long)nsPacket.getOptions().size());
    }
}

