/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduBasicParameterSet;
import org.onlab.packet.EAPOLMkpduDistributedSAKParameterSet;
import org.onlab.packet.EAPOLMkpduICVIndicatorParameterSet;
import org.onlab.packet.EAPOLMkpduMACSecUseParameterSet;
import org.onlab.packet.EAPOLMkpduParameterSet;
import org.onlab.packet.EAPOLMkpduPeerListParameterSet;
import org.onlab.packet.IPacket;

public class EAPOLMkpdu
extends BasePacket {
    private Map<Byte, IPacket> parameterSets = new LinkedHashMap<Byte, IPacket>();
    private static byte[] parametersetSerializerKeyList = new byte[]{0, 1, 2, 3, 4, -1};
    private static final Map<Byte, Deserializer<? extends IPacket>> PARAMETERSET_DESERIALIZER_MAP = new LinkedHashMap<Byte, Deserializer<? extends IPacket>>();

    @Override
    public byte[] serialize() {
        short payloadLength = this.packetLength();
        ByteBuffer payload = ByteBuffer.wrap(new byte[payloadLength]);
        for (byte b : parametersetSerializerKeyList) {
            byte[] data;
            IPacket packet = this.parameterSets.get(b);
            if (packet == null || (data = packet.serialize()) == null) continue;
            payload.put(data);
        }
        return payload.array();
    }

    public static Deserializer<EAPOLMkpdu> deserializer() {
        return (data, offset, length) -> {
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpdu mkpdu = new EAPOLMkpdu();
            Deserializer<? extends IPacket> psDeserializer = PARAMETERSET_DESERIALIZER_MAP.get((byte)0);
            EAPOLMkpduParameterSet ps = (EAPOLMkpduParameterSet)((Object)psDeserializer.deserialize(bb.array(), bb.position(), bb.remaining()));
            if (!mkpdu.addParameterSet((short)0, ps)) {
                throw new DeserializationException("Error in deserializing packets");
            }
            bb.position(bb.position() + ps.getTotalLength());
            while (bb.hasRemaining()) {
                byte parameterSetType = bb.get();
                psDeserializer = PARAMETERSET_DESERIALIZER_MAP.get(parameterSetType);
                ps = (EAPOLMkpduParameterSet)((Object)psDeserializer.deserialize(bb.array(), bb.position(), bb.remaining()));
                if (parameterSetType == 1 || parameterSetType == 2) {
                    EAPOLMkpduPeerListParameterSet peerList = (EAPOLMkpduPeerListParameterSet)ps;
                    peerList.setPeerListType(parameterSetType);
                }
                if (!mkpdu.addParameterSet(parameterSetType, ps)) {
                    throw new DeserializationException("Error in deserializing packets");
                }
                short consumed = ps.getTotalLength();
                int remaining = bb.remaining();
                bb.position(bb.position() + (remaining > consumed ? consumed - 1 : remaining));
            }
            return mkpdu;
        };
    }

    public boolean addParameterSet(short type, EAPOLMkpduParameterSet ps) {
        if (ps == null) {
            return false;
        }
        if ((0 > type || type > 4) && type != -1) {
            return false;
        }
        this.parameterSets.put((byte)type, (IPacket)((Object)ps));
        return true;
    }

    public EAPOLMkpduBasicParameterSet getBasicParameterSet() {
        IPacket parameterSet = null;
        if (this.parameterSets.containsKey((byte)0)) {
            parameterSet = this.parameterSets.get((byte)0);
        }
        return (EAPOLMkpduBasicParameterSet)parameterSet;
    }

    public EAPOLMkpduPeerListParameterSet getPeerListParameterSet() {
        IPacket parameterSet = this.parameterSets.containsKey((byte)1) ? this.parameterSets.get((byte)1) : this.parameterSets.get((byte)2);
        return (EAPOLMkpduPeerListParameterSet)parameterSet;
    }

    public short packetLength() {
        short length = 0;
        for (byte k : this.parameterSets.keySet()) {
            EAPOLMkpduParameterSet p = (EAPOLMkpduParameterSet)((Object)this.parameterSets.get(k));
            length = (short)(length + p.getTotalLength());
        }
        return length;
    }

    public EAPOLMkpduParameterSet getParameterSet(byte type) {
        EAPOLMkpduParameterSet ps = null;
        Map.Entry entry = this.parameterSets.entrySet().stream().filter(i -> ((Byte)i.getKey()).equals(new Byte(type))).findFirst().orElse(null);
        if (entry != null) {
            ps = (EAPOLMkpduParameterSet)entry.getValue();
        }
        return ps;
    }

    static {
        PARAMETERSET_DESERIALIZER_MAP.put((byte)0, EAPOLMkpduBasicParameterSet.deserializer());
        PARAMETERSET_DESERIALIZER_MAP.put((byte)1, EAPOLMkpduPeerListParameterSet.deserializer());
        PARAMETERSET_DESERIALIZER_MAP.put((byte)2, EAPOLMkpduPeerListParameterSet.deserializer());
        PARAMETERSET_DESERIALIZER_MAP.put((byte)3, EAPOLMkpduMACSecUseParameterSet.deserializer());
        PARAMETERSET_DESERIALIZER_MAP.put((byte)4, EAPOLMkpduDistributedSAKParameterSet.deserializer());
        PARAMETERSET_DESERIALIZER_MAP.put((byte)-1, EAPOLMkpduICVIndicatorParameterSet.deserializer());
    }
}

