/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;

public class ICMPEcho
extends BasePacket {
    private short identifier;
    private short sequenceNum;
    public static final short ICMP_ECHO_HEADER_LENGTH = 4;

    public ICMPEcho setIdentifier(short identifier) {
        this.identifier = identifier;
        return this;
    }

    public short getIdentifier() {
        return this.identifier;
    }

    public ICMPEcho setSequenceNum(short sequenceNum) {
        this.sequenceNum = sequenceNum;
        return this;
    }

    public short getSequenceNum() {
        return this.sequenceNum;
    }

    @Override
    public byte[] serialize() {
        int length = 4;
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
            length += payloadData.length;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.identifier);
        bb.putShort(this.sequenceNum);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.identifier;
        result = 5807 * result + this.sequenceNum;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ICMPEcho)) {
            return false;
        }
        ICMPEcho other = (ICMPEcho)obj;
        if (this.identifier != other.identifier) {
            return false;
        }
        return this.sequenceNum == other.sequenceNum;
    }

    public static Deserializer<ICMPEcho> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            ICMPEcho icmp = new ICMPEcho();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            icmp.identifier = bb.getShort();
            icmp.sequenceNum = bb.getShort();
            return icmp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ICMP echo identifier", (Object)Short.toString(this.identifier)).add("ICMP echo sequenceNumber", (Object)Short.toString(this.sequenceNum)).toString();
    }
}

