/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;

public class LLC
extends BasePacket {
    public static final byte LLC_HEADER_LENGTH = 3;
    private byte dsap = 0;
    private byte ssap = 0;
    private byte ctrl = 0;

    public byte getDsap() {
        return this.dsap;
    }

    public void setDsap(byte dsap) {
        this.dsap = dsap;
    }

    public byte getSsap() {
        return this.ssap;
    }

    public void setSsap(byte ssap) {
        this.ssap = ssap;
    }

    public byte getCtrl() {
        return this.ctrl;
    }

    public void setCtrl(byte ctrl) {
        this.ctrl = ctrl;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[3];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.dsap);
        bb.put(this.ssap);
        bb.put(this.ctrl);
        return data;
    }

    public static Deserializer<LLC> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 3);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            LLC llc = new LLC();
            llc.dsap = bb.get();
            llc.ssap = bb.get();
            llc.ctrl = bb.get();
            return llc;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("dsap", (Object)Byte.toString(this.dsap)).add("ssap", (Object)Byte.toString(this.ssap)).add("ctrl", (Object)Byte.toString(this.ctrl)).toString();
    }
}

