/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.junit.Assert;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;

public final class PacketTestUtils {
    private PacketTestUtils() {
    }

    public static void testDeserializeBadInput(Deserializer deserializer) {
        byte[] bytes = ByteBuffer.allocate(4).array();
        try {
            deserializer.deserialize(null, 0, 4);
            TestCase.fail((String)"NullPointerException was not thrown");
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)true);
        }
        catch (DeserializationException e) {
            TestCase.fail((String)"NullPointerException was not thrown");
        }
        PacketTestUtils.expectDeserializationException(deserializer, bytes, -1, 0);
        PacketTestUtils.expectDeserializationException(deserializer, bytes, 0, -1);
        PacketTestUtils.expectDeserializationException(deserializer, bytes, 0, 5);
        PacketTestUtils.expectDeserializationException(deserializer, bytes, 2, 3);
        PacketTestUtils.expectDeserializationException(deserializer, bytes, 5, 0);
    }

    public static void testDeserializeTruncated(Deserializer deserializer, byte[] header) {
        for (int i = 0; i < header.length; ++i) {
            byte[] truncated = new byte[i];
            ByteBuffer.wrap(header).get(truncated);
            PacketTestUtils.expectDeserializationException(deserializer, truncated, 0, truncated.length);
        }
    }

    public static void expectDeserializationException(Deserializer deserializer, byte[] bytes, int offset, int length) {
        try {
            deserializer.deserialize(bytes, offset, length);
            TestCase.fail((String)"DeserializationException was not thrown");
        }
        catch (DeserializationException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

