/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.Bandwidth;

public class LongBandwidthTest {
    private final long billion = 1000000000L;
    private final long one = 1L;
    Bandwidth notLongSmall = Bandwidth.kbps((double)1.0);
    private final Bandwidth notLongBig = Bandwidth.kbps((double)1000.0);
    private final Bandwidth big = Bandwidth.kbps((long)1000000000L);
    private final Bandwidth small = Bandwidth.kbps((long)1L);

    @Test
    public void testBps() {
        Bandwidth expected = Bandwidth.bps((long)1L);
        Assert.assertEquals((double)1.0, (double)expected.bps(), (double)0.0);
    }

    @Test
    public void testAdd() {
        long add = 1000000001L;
        Bandwidth expected = Bandwidth.kbps((long)1000000001L);
        Assert.assertThat((Object)this.big.add(this.small), (Matcher)Matchers.is((Object)expected));
        double notLongAdd = 1001.0;
        Bandwidth notLongExpected = Bandwidth.kbps((double)1001.0);
        Assert.assertThat((Object)this.notLongSmall.add(this.notLongBig), (Matcher)Matchers.is((Object)notLongExpected));
    }

    @Test
    public void testSubtract() {
        long sub = 999999999L;
        Bandwidth expected = Bandwidth.kbps((long)999999999L);
        Assert.assertThat((Object)this.big.subtract(this.small), (Matcher)Matchers.is((Object)expected));
        double notLongSubtract = 999.0;
        Bandwidth notLongExpected = Bandwidth.kbps((double)999.0);
        Assert.assertThat((Object)this.notLongBig.subtract(this.notLongSmall), (Matcher)Matchers.is((Object)notLongExpected));
    }

    @Test
    public void testLessThan() {
        Assert.assertThat((Object)this.small, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)this.big)));
        Assert.assertThat((Object)this.small.compareTo(this.big), (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)this.big, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)this.small)));
        Assert.assertThat((Object)this.big.compareTo(this.small), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.notLongSmall, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)this.notLongBig)));
        Assert.assertThat((Object)this.notLongSmall.compareTo(this.notLongBig), (Matcher)Matchers.is((Object)-1));
        Assert.assertThat((Object)this.notLongBig, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)this.notLongSmall)));
        Assert.assertThat((Object)this.notLongBig.compareTo(this.notLongSmall), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testEquals() {
        Bandwidth expected = Bandwidth.kbps((long)1L);
        Assert.assertFalse((boolean)this.small.equals(this.big));
        Assert.assertTrue((boolean)this.small.equals(expected));
        Assert.assertTrue((boolean)this.small.equals(this.small));
        Assert.assertFalse((boolean)this.small.equals(1000));
    }

    @Test
    public void testHashCode() {
        Long expected = 1000L;
        Assert.assertEquals((long)this.small.hashCode(), (long)expected.hashCode());
    }

    @Test
    public void testToString() {
        String expected = "1000";
        Assert.assertEquals((Object)this.small.toString(), (Object)expected);
    }
}

