/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.Bandwidth;

public class BandwidthTest {
    private final Bandwidth small = Bandwidth.kbps((double)100.0);
    private final Bandwidth large = Bandwidth.mbps((double)1.0);

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{Bandwidth.kbps((double)1000.0), Bandwidth.kbps((double)1000.0), Bandwidth.mbps((double)1.0)}).addEqualityGroup(new Object[]{Bandwidth.gbps((double)1.0)}).testEquals();
    }

    @Test
    public void testAdd() {
        Bandwidth expected = Bandwidth.kbps((double)1100.0);
        Assert.assertThat((Object)this.small.add(this.large), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testSubtract() {
        Bandwidth expected = Bandwidth.kbps((double)900.0);
        Assert.assertThat((Object)this.large.subtract(this.small), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testLessThan() {
        Assert.assertThat((Object)this.small, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)this.large)));
        Assert.assertThat((Object)this.small.isLessThan((Object)this.large), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testGreaterThan() {
        Assert.assertThat((Object)this.large, (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)this.small)));
        Assert.assertThat((Object)this.large.isGreaterThan((Object)this.small), (Matcher)Matchers.is((Object)true));
    }
}

