/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.BlockingAwareFuture;
import org.onlab.util.OrderedExecutor;
import org.onlab.util.SharedExecutors;
import org.onlab.util.Tools;

public class BlockingAwareFutureTest {
    @Test
    public void testNonBlockingThread() throws Exception {
        CompletableFuture future = new CompletableFuture();
        ExecutorService executor = SharedExecutors.getPoolThreadExecutor();
        BlockingAwareFuture blockingFuture = (BlockingAwareFuture)Tools.orderedFuture(future, (Executor)new OrderedExecutor((Executor)executor), (Executor)executor);
        CountDownLatch latch = new CountDownLatch(1);
        blockingFuture.thenRun(() -> latch.countDown());
        executor.execute(() -> future.complete("foo"));
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
        Assert.assertEquals((Object)"foo", (Object)blockingFuture.join());
        Assert.assertFalse((boolean)blockingFuture.isBlocked());
    }

    @Test
    public void testBlockingThread() throws Exception {
        CompletableFuture<String> future = new CompletableFuture<String>();
        ExecutorService executor = SharedExecutors.getPoolThreadExecutor();
        BlockingAwareFuture blockingFuture = (BlockingAwareFuture)Tools.orderedFuture(future, (Executor)new OrderedExecutor((Executor)executor), (Executor)executor);
        CountDownLatch latch = new CountDownLatch(2);
        CompletableFuture wrappedFuture = blockingFuture.thenApply(v -> {
            Assert.assertEquals((Object)"foo", (Object)v);
            latch.countDown();
            return v;
        });
        wrappedFuture.thenRun(() -> latch.countDown());
        executor.execute(() -> wrappedFuture.join());
        Thread.sleep(100L);
        Assert.assertTrue((boolean)blockingFuture.isBlocked());
        future.complete("foo");
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)latch.getCount());
        Assert.assertEquals((Object)"foo", (Object)blockingFuture.join());
        Assert.assertEquals((Object)"foo", wrappedFuture.join());
        Assert.assertFalse((boolean)blockingFuture.isBlocked());
    }
}

