/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.BreadthFirstSearchTest;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.Graph;
import org.onlab.graph.Path;
import org.onlab.graph.SrlgGraphSearch;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class SrlgGraphSearchTest
extends BreadthFirstSearchTest {
    @Override
    protected AbstractGraphPathSearch<TestVertex, TestEdge> graphSearch() {
        return new SrlgGraphSearch(null);
    }

    public void setDefaultWeights() {
        this.weigher = null;
    }

    @Override
    public void defaultGraphTest() {
    }

    @Override
    public void defaultHopCountWeight() {
    }

    @Test
    public void onePathPair() {
        this.setDefaultWeights();
        TestEdge aB = new TestEdge(A, B);
        TestEdge bC = new TestEdge(B, C);
        TestEdge aD = new TestEdge(A, D);
        TestEdge dC = new TestEdge(D, C);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)aB), (Object)((Object)bC), (Object)((Object)aD), (Object)((Object)dC)));
        HashMap<TestEdge, Integer> riskProfile = new HashMap<TestEdge, Integer>();
        riskProfile.put(aB, 0);
        riskProfile.put(bC, 0);
        riskProfile.put(aD, 1);
        riskProfile.put(dC, 1);
        SrlgGraphSearch search = new SrlgGraphSearch(2, riskProfile);
        Set paths = search.search((Graph)graph, (Vertex)A, (Vertex)C, this.weigher, -1).paths();
        System.out.println("\n\n\n" + paths + "\n\n\n");
        Assert.assertEquals((String)"one disjoint path pair found", (long)1L, (long)paths.size());
        this.checkIsDisjoint((Path<TestVertex, TestEdge>)((Path)paths.iterator().next()), riskProfile);
    }

    public void checkIsDisjoint(Path<TestVertex, TestEdge> p, Map<TestEdge, Integer> risks) {
        Assert.assertTrue((String)"The path is not a DisjointPathPair", (boolean)(p instanceof DisjointPathPair));
        DisjointPathPair q = (DisjointPathPair)p;
        HashSet<Integer> p1Risks = new HashSet<Integer>();
        for (TestEdge e : q.edges()) {
            p1Risks.add(risks.get((Object)e));
        }
        if (!q.hasBackup()) {
            return;
        }
        Path pq = q.secondary();
        for (TestEdge e : pq.edges()) {
            Assert.assertTrue((String)"The paths are not disjoint", (!p1Risks.contains(risks.get((Object)e)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void complexGraphTest() {
        this.setDefaultWeights();
        TestEdge aB = new TestEdge(A, B);
        TestEdge bC = new TestEdge(B, C);
        TestEdge aD = new TestEdge(A, D);
        TestEdge dC = new TestEdge(D, C);
        TestEdge cE = new TestEdge(C, E);
        TestEdge bE = new TestEdge(B, E);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)aB), (Object)((Object)bC), (Object)((Object)aD), (Object)((Object)dC), (Object)((Object)cE), (Object)((Object)bE), (Object[])new TestEdge[0]));
        HashMap<TestEdge, Integer> riskProfile = new HashMap<TestEdge, Integer>();
        riskProfile.put(aB, 0);
        riskProfile.put(bC, 0);
        riskProfile.put(aD, 1);
        riskProfile.put(dC, 1);
        riskProfile.put(cE, 2);
        riskProfile.put(bE, 3);
        SrlgGraphSearch search = new SrlgGraphSearch(4, riskProfile);
        search.search((Graph)graph, (Vertex)A, (Vertex)E, this.weigher, -1).paths();
    }

    @Test
    public void multiplePathGraphTest() {
        this.setDefaultWeights();
        TestEdge aB = new TestEdge(A, B);
        TestEdge bE = new TestEdge(B, E);
        TestEdge aD = new TestEdge(A, D);
        TestEdge dE = new TestEdge(D, E);
        TestEdge aC = new TestEdge(A, C);
        TestEdge cE = new TestEdge(C, E);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)aB), (Object)((Object)bE), (Object)((Object)aD), (Object)((Object)dE), (Object)((Object)aC), (Object)((Object)cE), (Object[])new TestEdge[0]));
        HashMap<TestEdge, Integer> riskProfile = new HashMap<TestEdge, Integer>();
        riskProfile.put(aB, 0);
        riskProfile.put(bE, 1);
        riskProfile.put(aD, 2);
        riskProfile.put(dE, 3);
        riskProfile.put(aC, 4);
        riskProfile.put(cE, 5);
        SrlgGraphSearch search = new SrlgGraphSearch(6, riskProfile);
        Set paths = search.search((Graph)graph, (Vertex)A, (Vertex)E, this.weigher, -1).paths();
        Assert.assertTrue((String)"> one disjoint path pair found", (paths.size() >= 1 ? 1 : 0) != 0);
        this.checkIsDisjoint((Path<TestVertex, TestEdge>)((Path)paths.iterator().next()), riskProfile);
    }

    @Test
    public void onePath() {
        this.setDefaultWeights();
        TestEdge aB = new TestEdge(A, B);
        TestEdge bC = new TestEdge(B, C);
        TestEdge aD = new TestEdge(A, D);
        TestEdge dC = new TestEdge(D, C);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)aB), (Object)((Object)bC), (Object)((Object)aD), (Object)((Object)dC)));
        HashMap<TestEdge, Integer> riskProfile = new HashMap<TestEdge, Integer>();
        riskProfile.put(aB, 0);
        riskProfile.put(bC, 0);
        riskProfile.put(aD, 1);
        riskProfile.put(dC, 0);
        SrlgGraphSearch search = new SrlgGraphSearch(2, riskProfile);
        Set paths = search.search((Graph)graph, (Vertex)A, (Vertex)C, this.weigher, -1).paths();
        System.out.println(paths);
        Assert.assertTrue((String)"no disjoint path pairs found", (paths.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void noPath() {
        this.setDefaultWeights();
        TestEdge aB = new TestEdge(A, B);
        TestEdge bC = new TestEdge(B, C);
        TestEdge aD = new TestEdge(A, D);
        TestEdge dC = new TestEdge(D, C);
        AdjacencyListsGraph graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E), (Set)ImmutableSet.of((Object)((Object)aB), (Object)((Object)bC), (Object)((Object)aD), (Object)((Object)dC)));
        HashMap<TestEdge, Integer> riskProfile = new HashMap<TestEdge, Integer>();
        riskProfile.put(aB, 0);
        riskProfile.put(bC, 0);
        riskProfile.put(aD, 1);
        riskProfile.put(dC, 0);
        SrlgGraphSearch search = new SrlgGraphSearch(2, riskProfile);
        Set paths = search.search((Graph)graph, (Vertex)A, (Vertex)E, this.weigher, -1).paths();
        Assert.assertTrue((String)"no disjoint path pairs found", (paths.size() == 0 ? 1 : 0) != 0);
    }
}

