/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PredictableExecutor
extends AbstractExecutorService
implements ExecutorService {
    private final List<ExecutorService> backends;

    public static PredictableExecutor newPredictableExecutor(int buckets, ThreadFactory threadFactory) {
        return new PredictableExecutor(buckets, threadFactory);
    }

    public PredictableExecutor(int buckets, ThreadFactory threadFactory) {
        this(buckets, threadFactory, false);
    }

    public PredictableExecutor(int buckets, ThreadFactory threadFactory, boolean directExec) {
        Preconditions.checkArgument((buckets >= 0 ? 1 : 0) != 0, (Object)"number of buckets must be non zero");
        Preconditions.checkNotNull((Object)threadFactory);
        if (buckets == 0) {
            buckets = Runtime.getRuntime().availableProcessors();
        }
        this.backends = new ArrayList<ExecutorService>(buckets);
        for (int i = 0; i < buckets; ++i) {
            this.backends.add(this.backendExecutorService(threadFactory, directExec));
        }
    }

    public PredictableExecutor(ThreadFactory threadFactory) {
        this(0, threadFactory);
    }

    protected ExecutorService backendExecutorService(ThreadFactory threadFactory, boolean direct) {
        return direct ? MoreExecutors.newDirectExecutorService() : Executors.newSingleThreadExecutor(threadFactory);
    }

    public void execute(Runnable command, int hint) {
        int index = Math.abs(hint) % this.backends.size();
        this.backends.get(index).execute(command);
    }

    public void execute(Runnable command, Function<Runnable, Integer> hintFunction) {
        this.execute(command, hintFunction.apply(command));
    }

    private static int hint(Runnable command) {
        if (command instanceof PickyTask) {
            return ((PickyTask)((Object)command)).hint();
        }
        return Objects.hashCode(command);
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, PredictableExecutor::hint);
    }

    @Override
    public void shutdown() {
        this.backends.forEach(ExecutorService::shutdown);
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.backends.stream().map(ExecutorService::shutdownNow).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isShutdown() {
        return this.backends.stream().allMatch(ExecutorService::isShutdown);
    }

    @Override
    public boolean isTerminated() {
        return this.backends.stream().allMatch(ExecutorService::isTerminated);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Duration timeoutD = Duration.of(unit.toMillis(timeout), ChronoUnit.MILLIS);
        Instant start = Instant.now();
        return this.backends.parallelStream().filter(es -> !es.isTerminated()).map(es -> {
            long timeoutMs = timeoutD.minus(Duration.between(Instant.now(), start)).toMillis();
            try {
                return es.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }).allMatch(result -> result);
    }

    protected <T> PickyFutureTask<T> newTaskFor(Callable<T> callable) {
        return new PickyFutureTask<T>(callable);
    }

    protected <T> PickyFutureTask<T> newTaskFor(Runnable runnable, T value) {
        return new PickyFutureTask<T>(runnable, value);
    }

    public static PickyRunnable picky(Runnable runnable, int hint) {
        return PredictableExecutor.picky(runnable, (Runnable r) -> hint);
    }

    public static PickyRunnable picky(final Runnable runnable, final Function<Runnable, Integer> hint) {
        Preconditions.checkNotNull((Object)runnable);
        Preconditions.checkNotNull(hint);
        return new PickyRunnable(){

            @Override
            public void run() {
                runnable.run();
            }

            @Override
            public int hint() {
                return (Integer)hint.apply(runnable);
            }
        };
    }

    public static <T> PickyCallable<T> picky(Callable<T> callable, int hint) {
        return PredictableExecutor.picky(callable, (Callable<T> c) -> hint);
    }

    public static <T> PickyCallable<T> picky(final Callable<T> callable, final Function<Callable<T>, Integer> hint) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(hint);
        return new PickyCallable<T>(){

            @Override
            public T call() throws Exception {
                return callable.call();
            }

            @Override
            public int hint() {
                return (Integer)hint.apply(callable);
            }
        };
    }

    public static class PickyFutureTask<T>
    extends FutureTask<T>
    implements PickyTask {
        private final Object runnableOrCallable;

        public PickyFutureTask(Runnable runnable, T value) {
            super(runnable, value);
            this.runnableOrCallable = Preconditions.checkNotNull((Object)runnable);
        }

        public PickyFutureTask(Callable<T> callable) {
            super(callable);
            this.runnableOrCallable = Preconditions.checkNotNull(callable);
        }

        @Override
        public int hint() {
            if (this.runnableOrCallable instanceof PickyTask) {
                return ((PickyTask)this.runnableOrCallable).hint();
            }
            return this.runnableOrCallable.hashCode();
        }
    }

    public static interface PickyTask {
        public int hint();
    }

    public static interface PickyCallable<T>
    extends PickyTask,
    Callable<T> {
    }

    public static interface PickyRunnable
    extends PickyTask,
    Runnable {
    }
}

