/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.util.Identifier;

public final class MplsLabel
extends Identifier<Integer> {
    public static final int MAX_MPLS = 1048575;

    protected MplsLabel(int value) {
        super(value);
    }

    public static MplsLabel mplsLabel(int value) {
        if (value < 0 || value > 1048575) {
            String errorMsg = "MPLS label value " + value + " is not in the interval [0, 0xFFFFF]";
            throw new IllegalArgumentException(errorMsg);
        }
        return new MplsLabel(value);
    }

    public static MplsLabel mplsLabel(String value) {
        try {
            return MplsLabel.mplsLabel(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int toInt() {
        return (Integer)this.id();
    }

    @Override
    public String toString() {
        return String.valueOf(this.identifier);
    }
}

