/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Objects;

@Beta
public final class ClosedOpenRange {
    private final int lowerBound;
    private final int upperBound;

    public static ClosedOpenRange of(Range<Integer> range) {
        return new ClosedOpenRange((Integer)range.canonical(DiscreteDomain.integers()).lowerEndpoint(), (Integer)range.canonical(DiscreteDomain.integers()).upperEndpoint());
    }

    public static ClosedOpenRange of(int lowerBound, int upperBound) {
        return new ClosedOpenRange(lowerBound, upperBound);
    }

    private ClosedOpenRange(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public int upperBound() {
        return this.upperBound;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClosedOpenRange)) {
            return false;
        }
        ClosedOpenRange other = (ClosedOpenRange)obj;
        return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
    }

    public String toString() {
        return "[" + this.lowerBound + ".." + this.upperBound + ")";
    }
}

