/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.onlab.packet.ARP;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOL;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.LLDP;
import org.onlab.packet.MPLS;
import org.onlab.packet.Slow;

public class EthType {
    private final short etherType;

    public EthType(int etherType) {
        this.etherType = (short)(etherType & 0xFFFF);
    }

    public EthType(short etherType) {
        this.etherType = etherType;
    }

    public short toShort() {
        return this.etherType;
    }

    public EtherType lookup(short etherType) {
        for (EtherType ethType : EtherType.values()) {
            if (ethType.ethType().toShort() != etherType) continue;
            return ethType;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthType ethType = (EthType)o;
        return this.etherType == ethType.etherType;
    }

    public int hashCode() {
        return this.etherType;
    }

    public String toString() {
        EtherType ethType = this.lookup(this.etherType);
        return ethType == null ? String.format("0x%04x", this.etherType) : ethType.toString();
    }

    public static enum EtherType {
        ARP(2054, "arp", org.onlab.packet.ARP.deserializer()),
        RARP(32821, "rarp", org.onlab.packet.ARP.deserializer()),
        IPV4(2048, "ipv4", IPv4.deserializer()),
        IPV6(34525, "ipv6", IPv6.deserializer()),
        LLDP(35020, "lldp", org.onlab.packet.LLDP.deserializer()),
        VLAN(33024, "vlan", null),
        QINQ(34984, "qinq", null),
        BDDP(35138, "bddp", org.onlab.packet.LLDP.deserializer()),
        MPLS_UNICAST(34887, "mpls_unicast", MPLS.deserializer()),
        MPLS_MULTICAST(34888, "mpls_multicast", MPLS.deserializer()),
        EAPOL(34958, "eapol", org.onlab.packet.EAPOL.deserializer()),
        SLOW(34825, "slow", Slow.deserializer()),
        UNKNOWN(0, "unknown", null);

        private final EthType etherType;
        private final String type;
        private final Deserializer<?> deserializer;

        private EtherType(int ethType, String type, Deserializer<?> deserializer) {
            this.etherType = new EthType(ethType);
            this.type = type;
            this.deserializer = deserializer;
        }

        public EthType ethType() {
            return this.etherType;
        }

        public String toString() {
            return this.type;
        }

        public Deserializer<?> deserializer() {
            return this.deserializer;
        }

        public static EtherType lookup(short etherType) {
            for (EtherType ethType : EtherType.values()) {
                if (ethType.ethType().toShort() != etherType) continue;
                return ethType;
            }
            return UNKNOWN;
        }
    }
}

