/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.UDP;

public class IpTest {
    private byte v4Version = (byte)4;
    private byte v4HeaderLength = (byte)6;
    private byte badVersion = (byte)5;
    private byte badHeaderLength = (byte)6;
    private static Data data;
    private static UDP udp;
    private byte[] v4HeaderBytes;
    private byte[] v6HeaderBytes;
    private byte[] badHeaderBytes;

    @Before
    public void setUp() throws Exception {
        ByteBuffer v4bb = ByteBuffer.allocate(this.v4HeaderLength * 4);
        v4bb.put((byte)((this.v4Version & 0xF) << 4));
        this.v4HeaderBytes = v4bb.array();
        ByteBuffer badBb = ByteBuffer.allocate(this.badHeaderLength * 4);
        badBb.put((byte)((this.badVersion & 0xF) << 4));
        this.badHeaderBytes = badBb.array();
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{105, 49, 53, 121, (byte)(bytePayload.length >> 8 & 0xFF), (byte)(bytePayload.length & 0xFF), 17, 32, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50, 32, 1, 15, 24, 1, 19, 2, 21, -26, -50, -113, -1, -2, 84, 55, -56};
        this.v6HeaderBytes = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, this.v6HeaderBytes, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, this.v6HeaderBytes, byteHeader.length, bytePayload.length);
    }

    @Test
    public void testDeserialize() throws Exception {
        Deserializer ipDeserializer = IP.deserializer();
        IPacket v4Packet = ipDeserializer.deserialize(this.v4HeaderBytes, 0, this.v4HeaderLength * 4);
        IPacket v6Packet = ipDeserializer.deserialize(this.v6HeaderBytes, 0, this.v6HeaderBytes.length);
        MatcherAssert.assertThat((Object)v4Packet, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IPv4.class)));
        MatcherAssert.assertThat((Object)v6Packet, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(IPv6.class)));
        IPv6 ipv6 = (IPv6)v6Packet;
        MatcherAssert.assertThat((Object)ipv6.getVersion(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)ipv6.getTrafficClass(), (Matcher)Matchers.is((Object)-109));
        MatcherAssert.assertThat((Object)ipv6.getFlowLabel(), (Matcher)Matchers.is((Object)79225));
        MatcherAssert.assertThat((Object)ipv6.getNextHeader(), (Matcher)Matchers.is((Object)17));
        MatcherAssert.assertThat((Object)ipv6.getHopLimit(), (Matcher)Matchers.is((Object)32));
    }

    @Test(expected=DeserializationException.class)
    public void testBadIpVersion() throws Exception {
        Deserializer ipDeserializer = IP.deserializer();
        ipDeserializer.deserialize(this.badHeaderBytes, 0, this.badHeaderLength * 4);
    }
}

