/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.util.BlockingBoolean;

public class BlockingBooleanTest {
    private static final int FAIL_TIMEOUT = 1000;

    @Test
    public void basics() {
        BlockingBoolean b = new BlockingBoolean(false);
        Assert.assertEquals((Object)false, (Object)b.get());
        b.set(true);
        Assert.assertEquals((Object)true, (Object)b.get());
        b.set(true);
        Assert.assertEquals((Object)true, (Object)b.get());
        b.set(false);
        Assert.assertEquals((Object)false, (Object)b.get());
    }

    private void waitChange(boolean value, int numThreads) {
        BlockingBoolean b = new BlockingBoolean(!value);
        CountDownLatch latch = new CountDownLatch(numThreads);
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            exec.submit(() -> {
                try {
                    b.await(value);
                    latch.countDown();
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
            });
        }
        b.set(value);
        try {
            Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        exec.shutdown();
    }

    @Test
    public void waitTrueChange() {
        this.waitChange(true, 4);
    }

    @Test
    public void waitFalseChange() {
        this.waitChange(false, 4);
    }

    @Test
    public void waitSame() {
        BlockingBoolean b = new BlockingBoolean(true);
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.submit(() -> {
            try {
                b.await(true);
                latch.countDown();
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
        });
        try {
            Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        exec.shutdown();
    }

    @Test
    public void someWait() {
        BlockingBoolean b = new BlockingBoolean(false);
        int numThreads = 4;
        CountDownLatch sameLatch = new CountDownLatch(numThreads / 2);
        CountDownLatch waitLatch = new CountDownLatch(numThreads / 2);
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            boolean value = i % 2 == 1;
            exec.submit(() -> {
                try {
                    b.await(value);
                    if (value) {
                        waitLatch.countDown();
                    } else {
                        sameLatch.countDown();
                    }
                }
                catch (InterruptedException e) {
                    Assert.fail();
                }
            });
        }
        try {
            Assert.assertTrue((boolean)sameLatch.await(1000L, TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)waitLatch.getCount(), (long)(numThreads / 2));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        b.set(true);
        try {
            Assert.assertTrue((boolean)waitLatch.await(1000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        exec.shutdown();
    }

    @Test
    public void waitTimeout() {
        BlockingBoolean b = new BlockingBoolean(true);
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.submit(() -> {
            try {
                if (!b.await(false, 1L, TimeUnit.NANOSECONDS)) {
                    latch.countDown();
                } else {
                    Assert.fail();
                }
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
        });
        try {
            Assert.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        exec.shutdown();
    }

    @Test
    @Ignore
    public void samePerf() {
        long t3;
        int iters = 10000;
        BlockingBoolean b1 = new BlockingBoolean(false);
        long t1 = System.nanoTime();
        for (int i = 0; i < iters; ++i) {
            b1.set(false);
        }
        long t2 = System.nanoTime();
        MutableBoolean b2 = new MutableBoolean(false);
        for (int i = 0; i < iters; ++i) {
            b2.setValue(false);
        }
        System.out.println(t2 - t1 + " " + (t3 - t2) + " " + (t2 - t1 <= (t3 = System.nanoTime()) - t2));
    }

    @Test
    @Ignore
    public void changePerf() {
        long t3;
        int iters = 10000;
        BlockingBoolean b1 = new BlockingBoolean(false);
        boolean v = true;
        long t1 = System.nanoTime();
        for (int i = 0; i < iters; ++i) {
            b1.set(v);
            v = !v;
        }
        long t2 = System.nanoTime();
        MutableBoolean b2 = new MutableBoolean(false);
        for (int i = 0; i < iters; ++i) {
            b2.setValue(v);
            v = !v;
        }
        System.out.println(t2 - t1 + " " + (t3 - t2) + " " + (t2 - t1 <= (t3 = System.nanoTime()) - t2));
    }
}

