/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.RIPV2AuthEntry;
import org.onlab.packet.RIPV2Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIP
extends BasePacket {
    public static final int MIN_HEADER_LENGTH = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected byte cmdType;
    protected byte version;
    protected short reserved;
    protected List<RIPV2Entry> rtEntries = new ArrayList<RIPV2Entry>();
    protected RIPV2AuthEntry authEntry = null;
    protected byte[] rawData = null;

    public byte getCmdType() {
        return this.cmdType;
    }

    public RIP setCmdType(byte cmdType) {
        this.cmdType = cmdType;
        return this;
    }

    public byte getVersion() {
        return this.version;
    }

    public RIP setVersion(byte version) {
        this.version = version;
        return this;
    }

    public short getReserved() {
        return this.reserved;
    }

    public RIP setReserved(short reserved) {
        this.reserved = reserved;
        return this;
    }

    public List<RIPV2Entry> getRtEntries() {
        return this.rtEntries;
    }

    public RIP setRtEntries(List<RIPV2Entry> entries) {
        this.rtEntries = entries;
        return this;
    }

    public RIPV2AuthEntry getAuthEntry() {
        return this.authEntry;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    @Override
    public byte[] serialize() {
        this.resetChecksum();
        int dataLength = 4 + 20 * this.rtEntries.size();
        if (this.authEntry != null) {
            dataLength += 20;
        }
        byte[] data = new byte[dataLength];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.cmdType);
        bb.put(this.version);
        bb.putShort(this.reserved);
        if (this.authEntry != null) {
            bb.put(this.authEntry.serialize());
        }
        for (RIPV2Entry entry : this.rtEntries) {
            bb.put(entry.serialize());
        }
        return data;
    }

    public static Deserializer<RIP> deserializer() {
        return (data, offset, length) -> {
            RIP rip = new RIP();
            PacketUtils.checkInput(data, offset, length, 4);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            rip.rawData = Arrays.copyOfRange(data, offset, offset + length);
            rip.cmdType = bb.get();
            rip.version = bb.get();
            rip.reserved = bb.getShort();
            while (bb.hasRemaining() && bb.remaining() >= 20) {
                byte[] rtData = new byte[20];
                bb.get(rtData);
                if (rtData[0] == -1 && rtData[1] == -1) {
                    if (rip.authEntry != null) continue;
                    rip.authEntry = RIPV2AuthEntry.deserializer().deserialize(rtData, 0, rtData.length);
                    continue;
                }
                RIPV2Entry rtEntry = RIPV2Entry.deserializer().deserialize(rtData, 0, rtData.length);
                rip.rtEntries.add(rtEntry);
            }
            return rip;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cmdType, this.reserved, this.version, this.authEntry, this.rtEntries);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RIP)) {
            return false;
        }
        RIP that = (RIP)obj;
        return super.equals(that) && Objects.equals(this.version, that.version) && Objects.equals(this.reserved, that.reserved) && Objects.equals(this.cmdType, that.cmdType) && Objects.equals(this.authEntry, that.authEntry) && Objects.equals(this.rtEntries, that.rtEntries);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("cmdType", (Object)Byte.toString(this.cmdType)).add("version", (Object)Byte.toString(this.version)).add("reserved", (Object)Short.toString(this.reserved)).toString();
    }

    public static enum CmdType {
        RIPREQUEST(1),
        RIPRESPONSE(2);

        protected int value;

        private CmdType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CmdType getType(int value) {
            switch (value) {
                case 1: {
                    return RIPREQUEST;
                }
                case 2: {
                    return RIPRESPONSE;
                }
            }
            return null;
        }
    }
}

