/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;

public final class FilePathValidator {
    private FilePathValidator() {
    }

    public static boolean validateFile(File destinationFile, File destinationDir) {
        try {
            String canonicalDestinationDirPath = destinationDir.getCanonicalPath();
            String canonicalDestinationFile = destinationFile.getCanonicalPath();
            return canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean validateZipEntry(ZipEntry entry, File destinationDir) {
        try {
            String canonicalDestinationDirPath = destinationDir.getCanonicalPath();
            File destinationFile = new File(destinationDir, entry.getName());
            String canonicalDestinationFile = destinationFile.getCanonicalPath();
            return canonicalDestinationFile.startsWith(canonicalDestinationDirPath + File.separator);
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

