/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6IaPrefixOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 25;
    private Ip6Address ip6Prefix;
    private byte prefixLength;
    private int preferredLifetime;
    private int validLifetime;
    private IPacket options;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.IAPREFIX.value();
    }

    @Override
    public short getLength() {
        return (short)(this.options == null ? 25 : 25 + this.options.serialize().length);
    }

    public void setIp6Prefix(Ip6Address ip6Prefix) {
        this.ip6Prefix = ip6Prefix;
    }

    public void setPrefixLength(byte prefixLength) {
        this.prefixLength = prefixLength;
    }

    public void setPreferredLifetime(int preferredLifetime) {
        this.preferredLifetime = preferredLifetime;
    }

    public void setValidLifetime(int validLifetime) {
        this.validLifetime = validLifetime;
    }

    public void setOptions(IPacket options) {
        this.options = options;
    }

    public Ip6Address getIp6Prefix() {
        return this.ip6Prefix;
    }

    public byte getPrefixLength() {
        return this.prefixLength;
    }

    public int getPreferredLifetime() {
        return this.preferredLifetime;
    }

    public int getValidLifetime() {
        return this.validLifetime;
    }

    public IPacket getOptions() {
        return this.options;
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6IaPrefixOption iaPrefixOption = new Dhcp6IaPrefixOption();
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            iaPrefixOption.setPayload(dhcp6Option.getPayload());
            if (dhcp6Option.getLength() < 25) {
                throw new DeserializationException("Invalid length of IA prefix option");
            }
            ByteBuffer bb = ByteBuffer.wrap(dhcp6Option.getData());
            iaPrefixOption.preferredLifetime = bb.getInt();
            iaPrefixOption.validLifetime = bb.getInt();
            iaPrefixOption.prefixLength = bb.get();
            byte[] ipv6Pref = new byte[16];
            bb.get(ipv6Pref);
            iaPrefixOption.ip6Prefix = Ip6Address.valueOf(ipv6Pref);
            int optionsLen = dhcp6Option.getLength() - 25;
            if (optionsLen > 0) {
                byte[] optionsData = new byte[optionsLen];
                bb.get(optionsData);
                iaPrefixOption.options = Data.deserializer().deserialize(optionsData, 0, optionsLen);
            }
            return iaPrefixOption;
        };
    }

    @Override
    public byte[] serialize() {
        int payloadLen = this.options == null ? 25 : 25 + this.options.serialize().length;
        ByteBuffer bb = ByteBuffer.allocate(payloadLen + 4);
        bb.putShort(DHCP6.OptionCode.IAPREFIX.value());
        bb.putShort((short)payloadLen);
        bb.putInt(this.preferredLifetime);
        bb.putInt(this.validLifetime);
        bb.put(this.prefixLength);
        bb.put(this.ip6Prefix.toOctets());
        if (this.options != null) {
            bb.put(this.options.serialize());
        }
        return bb.array();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ip6Prefix, this.prefixLength, this.preferredLifetime, this.validLifetime, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dhcp6IaPrefixOption)) {
            return false;
        }
        Dhcp6IaPrefixOption other = (Dhcp6IaPrefixOption)obj;
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.preferredLifetime, other.preferredLifetime) && Objects.equals(this.validLifetime, other.validLifetime) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.ip6Prefix, other.ip6Prefix) && Objects.equals(this.options, other.options);
    }

    @Override
    public String toString() {
        return this.getToStringHelper().add("preferredLifetime", this.preferredLifetime).add("validLifetime", this.validLifetime).add("prefixLength", (int)this.prefixLength).add("ip6Address", (Object)this.ip6Prefix).add("options", (Object)this.options).toString();
    }
}

