/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.DisjointPathPair;
import org.onlab.graph.GraphTest;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Weight;

public class DisjointPathPairTest {
    private static final TestVertex A = new TestVertex("A");
    private static final TestVertex B = new TestVertex("B");
    private static final TestVertex C = new TestVertex("C");
    private static final TestVertex D = new TestVertex("D");
    private static final TestEdge AB = new TestEdge(A, B);
    private static final TestEdge BC = new TestEdge(B, C);
    private static final TestEdge AD = new TestEdge(A, D);
    private static final TestEdge DC = new TestEdge(D, C);
    private static final Path<TestVertex, TestEdge> ABC = new DefaultPath((List)ImmutableList.of((Object)((Object)AB), (Object)((Object)BC)), (Weight)GraphTest.W1);
    private static final Path<TestVertex, TestEdge> ADC = new DefaultPath((List)ImmutableList.of((Object)((Object)AD), (Object)((Object)DC)), (Weight)GraphTest.W1);

    @Test
    public void testSwappingPrimarySecondaryDoesntImpactHashCode() {
        Assert.assertEquals((long)new DisjointPathPair(ABC, ADC).hashCode(), (long)new DisjointPathPair(ADC, ABC).hashCode());
    }

    @Test
    public void testSwappingPrimarySecondaryDoesntImpactEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{new DisjointPathPair(ABC, ADC), new DisjointPathPair(ADC, ABC)}).testEquals();
    }
}

