/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.AdjacencyListsGraph;
import org.onlab.graph.GraphTest;
import org.onlab.graph.LazyKShortestPathsSearch;
import org.onlab.graph.Path;
import org.onlab.graph.TestEdge;
import org.onlab.graph.TestVertex;
import org.onlab.graph.Vertex;

public class LazyKShortestPathsSearchTest
extends GraphTest {
    LazyKShortestPathsSearch<TestVertex, TestEdge> sut;

    @Before
    public void setUp() {
        this.sut = new LazyKShortestPathsSearch();
    }

    @Test
    public void noPath() {
        this.graph = new AdjacencyListsGraph((Set)ImmutableSet.of((Object)A, (Object)B, (Object)C, (Object)D), (Set)ImmutableSet.of((Object)((Object)new TestEdge(A, B)), (Object)((Object)new TestEdge(B, A)), (Object)((Object)new TestEdge(C, D)), (Object)((Object)new TestEdge(D, C))));
        Stream result = this.sut.lazyPathSearch(this.graph, (Vertex)A, (Vertex)D, this.weigher);
        Assert.assertEquals((String)"There should not be any paths.", (long)0L, (long)result.count());
    }

    @Test
    public void fourPath() {
        this.graph = new AdjacencyListsGraph(this.vertexes(), this.edges());
        Stream result = this.sut.lazyPathSearch(this.graph, (Vertex)A, (Vertex)E, this.weigher);
        List rList = result.limit(42L).collect(Collectors.toList());
        Assert.assertEquals((String)"There are an unexpected number of paths.", (long)4L, (long)rList.size());
        ArrayList<TestEdge> expectedEdges = new ArrayList<TestEdge>();
        expectedEdges.add(new TestEdge(A, B, W1));
        expectedEdges.add(new TestEdge(B, C, W1));
        expectedEdges.add(new TestEdge(C, E, W1));
        Assert.assertEquals((String)"The first path from A to E was incorrect.", expectedEdges, (Object)((Path)rList.get(0)).edges());
        Assert.assertEquals((Object)W3, (Object)((Path)rList.get(0)).cost());
        expectedEdges.clear();
        expectedEdges.add(new TestEdge(A, C, W3));
        expectedEdges.add(new TestEdge(C, E, W1));
        ArrayList<TestEdge> alternateEdges = new ArrayList<TestEdge>();
        alternateEdges.add(new TestEdge(A, B, W1));
        alternateEdges.add(new TestEdge(B, D, W2));
        alternateEdges.add(new TestEdge(D, E, W1));
        Assert.assertThat((Object)ImmutableList.of((Object)((Path)rList.get(1)).edges(), (Object)((Path)rList.get(2)).edges()), (Matcher)Matchers.containsInAnyOrder((Object[])new List[]{expectedEdges, alternateEdges}));
        Assert.assertEquals((Object)W4, (Object)((Path)rList.get(1)).cost());
        Assert.assertEquals((Object)W4, (Object)((Path)rList.get(2)).cost());
        expectedEdges.clear();
        expectedEdges.add(new TestEdge(A, B, W1));
        expectedEdges.add(new TestEdge(B, E, W4));
        Assert.assertEquals((String)"The fourth path rom A to E was incorrect", expectedEdges, (Object)((Path)rList.get(3)).edges());
        Assert.assertEquals((Object)W5, (Object)((Path)rList.get(3)).cost());
    }
}

