/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.testing.EqualsTester;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketTestUtils;
import org.onlab.packet.UDP;
import org.onlab.packet.VXLAN;

public class VXLANTest {
    private static final byte[] BYTE_PACKET_VXLAN = new byte[]{8, 0, 0, 0, 18, 52, 86, 0};
    private static Deserializer<VXLAN> deserializer;
    private static final UDP UDP_HDR;
    private static final int TEST_UDP_SRCPORT = 80;
    private static final int TEST_FLAGS = 8;
    private static final int TEST_VNI1 = 1193046;
    private static final int TEST_VNI2 = 6636321;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        deserializer = VXLAN.deserializer();
        UDP_HDR.setSourcePort(80);
        UDP_HDR.setDestinationPort(4789);
    }

    @Test
    public void testSerialize() {
        VXLAN vxlan = new VXLAN();
        vxlan.setFlag((byte)8);
        vxlan.setVni(1193046);
        vxlan.setParent((IPacket)UDP_HDR);
        Assert.assertArrayEquals((String)"Serialized packet is not matched", (byte[])BYTE_PACKET_VXLAN, (byte[])vxlan.serialize());
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(deserializer, BYTE_PACKET_VXLAN);
    }

    @Test
    public void testDeserialize() throws Exception {
        VXLAN vxlan = (VXLAN)deserializer.deserialize(BYTE_PACKET_VXLAN, 0, BYTE_PACKET_VXLAN.length);
        Assert.assertThat((Object)vxlan.getFlag(), (Matcher)Matchers.is((Object)8));
        Assert.assertThat((Object)vxlan.getVni(), (Matcher)Matchers.is((Object)1193046));
    }

    @Test
    public void testEqual() {
        VXLAN vxlan1 = new VXLAN();
        vxlan1.setFlag((byte)8);
        vxlan1.setVni(1193046);
        VXLAN vxlan2 = new VXLAN();
        vxlan2.setFlag((byte)8);
        vxlan2.setVni(6636321);
        new EqualsTester().addEqualityGroup(new Object[]{vxlan1, vxlan1}).addEqualityGroup(new Object[]{vxlan2}).testEquals();
    }

    @Test
    public void testToStringVXLAN() throws Exception {
        VXLAN vxlan = (VXLAN)deserializer.deserialize(BYTE_PACKET_VXLAN, 0, BYTE_PACKET_VXLAN.length);
        String str = vxlan.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"flags=8"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"vni=1193046"));
    }

    static {
        UDP_HDR = new UDP();
    }
}

