/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.lacp.LacpTlv;

public class LacpCollectorTlv
extends LacpTlv {
    public static final byte LENGTH = 16;
    private static final byte[] RESERVED = new byte[12];
    private short collectorMaxDelay;

    public short getCollectorMaxDelay() {
        return this.collectorMaxDelay;
    }

    public LacpCollectorTlv setCollectorMaxDelay(short collectorMaxDelay) {
        this.collectorMaxDelay = collectorMaxDelay;
        return this;
    }

    public static Deserializer<LacpCollectorTlv> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 14);
            LacpCollectorTlv lacpCollectorTlv = new LacpCollectorTlv();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            lacpCollectorTlv.setCollectorMaxDelay(bb.getShort());
            return lacpCollectorTlv;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[14];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.collectorMaxDelay);
        bb.put(RESERVED);
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LacpCollectorTlv)) {
            return false;
        }
        LacpCollectorTlv other = (LacpCollectorTlv)obj;
        return this.collectorMaxDelay == other.collectorMaxDelay;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.collectorMaxDelay});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("collectorMaxDelay", (Object)Short.toString(this.collectorMaxDelay)).toString();
    }
}

