/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.RIPngEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIPng
extends BasePacket {
    public static final int MIN_HEADER_LENGTH = 4;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected byte cmdType;
    protected byte version;
    protected short reserved;
    protected List<RIPngEntry> rtEntries = new ArrayList<RIPngEntry>();

    public byte getCmdType() {
        return this.cmdType;
    }

    public RIPng setCmdType(byte cmdType) {
        this.cmdType = cmdType;
        return this;
    }

    public byte getVersion() {
        return this.version;
    }

    public RIPng setVersion(byte version) {
        this.version = version;
        return this;
    }

    public short getReserved() {
        return this.reserved;
    }

    public RIPng setReserved(short reserved) {
        this.reserved = reserved;
        return this;
    }

    public List<RIPngEntry> getRtEntries() {
        return this.rtEntries;
    }

    public RIPng setRtEntries(List<RIPngEntry> entries) {
        this.rtEntries = entries;
        return this;
    }

    @Override
    public byte[] serialize() {
        this.resetChecksum();
        byte[] data = new byte[4 + 20 * this.rtEntries.size()];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.cmdType);
        bb.put(this.version);
        bb.putShort(this.reserved);
        for (RIPngEntry entry : this.rtEntries) {
            bb.put(entry.serialize());
        }
        return data;
    }

    public static Deserializer<RIPng> deserializer() {
        return (data, offset, length) -> {
            RIPng ripng = new RIPng();
            PacketUtils.checkInput(data, offset, length, 4);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            ripng.cmdType = bb.get();
            ripng.version = bb.get();
            ripng.reserved = bb.getShort();
            while (bb.hasRemaining() && bb.remaining() >= 20) {
                byte[] rtData = new byte[20];
                bb.get(rtData);
                RIPngEntry rtEntry = RIPngEntry.deserializer().deserialize(rtData, 0, rtData.length);
                ripng.rtEntries.add(rtEntry);
            }
            return ripng;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.cmdType, this.reserved, this.version, this.rtEntries);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RIPng)) {
            return false;
        }
        RIPng that = (RIPng)obj;
        return super.equals(that) && Objects.equals(this.version, that.version) && Objects.equals(this.reserved, that.reserved) && Objects.equals(this.cmdType, that.cmdType) && Objects.equals(this.rtEntries, that.rtEntries);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("cmdType", (Object)Byte.toString(this.cmdType)).add("version", (Object)Byte.toString(this.version)).add("reserved", (Object)Short.toString(this.reserved)).toString();
    }

    public static enum CmdType {
        RIPngREQUEST(1),
        RIPngRESPONSE(2);

        protected int value;

        private CmdType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CmdType getType(int value) {
            switch (value) {
                case 1: {
                    return RIPngREQUEST;
                }
                case 2: {
                    return RIPngRESPONSE;
                }
            }
            return null;
        }
    }
}

