/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import java.util.HashSet;
import org.onlab.graph.AbstractGraphPathSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class BreadthFirstSearch<V extends Vertex, E extends Edge<V>>
extends AbstractGraphPathSearch<V, E> {
    @Override
    protected GraphPathSearch.Result<V, E> internalSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher, int maxPaths) {
        AbstractGraphPathSearch.DefaultResult result = new AbstractGraphPathSearch.DefaultResult((AbstractGraphPathSearch)this, src, dst, maxPaths);
        HashSet<V> frontier = new HashSet<V>();
        result.updateVertex(src, null, weigher.getInitialWeight(), true);
        frontier.add(src);
        boolean reachedEnd = false;
        while (!reachedEnd && !frontier.isEmpty()) {
            HashSet next = new HashSet();
            block1: for (Vertex vertex : frontier) {
                Weight cost = result.cost(vertex);
                for (Edge edge : graph.getEdgesFrom(vertex)) {
                    Object nextVertex = edge.dst();
                    if (!result.hasCost(nextVertex)) {
                        Weight newCost = cost.merge(weigher.weight(edge));
                        result.updateVertex(nextVertex, edge, newCost, true);
                        if (nextVertex.equals(dst)) {
                            reachedEnd = true;
                            continue block1;
                        }
                        next.add(nextVertex);
                    }
                    if (!reachedEnd) continue;
                    continue block1;
                }
            }
            frontier = next;
        }
        result.buildPaths();
        return result;
    }
}

