/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.onlab.graph.DefaultPath;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.Edge;
import org.onlab.graph.EdgeWeigher;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.Vertex;
import org.onlab.graph.Weight;

public class LazyKShortestPathsSearch<V extends Vertex, E extends Edge<V>> {
    private final Comparator<Path<V, E>> pathComparator = new PathComparator();
    private final GraphPathSearch<V, E> shortest = new DijkstraGraphSearch();

    public Stream<Path<V, E>> lazyPathSearch(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher) {
        ShortestPathIterator it = new ShortestPathIterator(this, graph, src, dst, weigher);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1297), false);
    }

    private final class PathComparator
    implements Comparator<Path<V, E>> {
        private PathComparator() {
        }

        @Override
        public int compare(Path<V, E> pathOne, Path<V, E> pathTwo) {
            return ComparisonChain.start().compare((Comparable)pathOne.cost(), (Comparable)pathTwo.cost()).compare(pathOne.edges().size(), pathTwo.edges().size()).result();
        }
    }

    private final class InnerEdgeWeigher
    implements EdgeWeigher<V, E> {
        private final Set<E> excluded = Sets.newConcurrentHashSet();
        private final EdgeWeigher<V, E> weigher;

        private InnerEdgeWeigher(EdgeWeigher<V, E> weigher) {
            this.weigher = weigher;
        }

        @Override
        public Weight weight(E edge) {
            if (this.excluded.contains(edge)) {
                return this.weigher.getNonViableWeight();
            }
            return this.weigher.weight(edge);
        }

        @Override
        public Weight getInitialWeight() {
            return this.weigher.getInitialWeight();
        }

        @Override
        public Weight getNonViableWeight() {
            return this.weigher.getNonViableWeight();
        }
    }

    private static final class ShortestPathIterator
    implements Iterator<Path<V, E>> {
        final Graph<V, E> graph;
        final V src;
        final V dst;
        final EdgeWeigher<V, E> weigher;
        final InnerEdgeWeigher maskingWeigher;
        final List<Path<V, E>> resultPaths = new ArrayList();
        final Queue<Path<V, E>> potentialPaths;
        Supplier<Path<V, E>> next;
        final /* synthetic */ LazyKShortestPathsSearch this$0;

        ShortestPathIterator(Graph<V, E> graph, V src, V dst, EdgeWeigher<V, E> weigher) {
            this.this$0 = var1_1;
            this.potentialPaths = new PriorityQueue(this.this$0.pathComparator);
            this.graph = (Graph)Preconditions.checkNotNull(graph);
            this.src = (Vertex)Preconditions.checkNotNull(src);
            this.dst = (Vertex)Preconditions.checkNotNull(dst);
            this.weigher = (EdgeWeigher)Preconditions.checkNotNull(weigher);
            this.maskingWeigher = var1_1.new InnerEdgeWeigher(weigher);
            this.next = Suppliers.ofInstance((Object)var1_1.shortest.search(graph, src, dst, weigher, 1).paths().stream().findFirst().orElse(null));
        }

        @Override
        public boolean hasNext() {
            return this.next.get() != null;
        }

        @Override
        public Path<V, E> next() {
            if (this.next.get() == null) {
                throw new NoSuchElementException("No more path between " + this.src + "-" + this.dst);
            }
            Path lastPath = this.next.get();
            this.resultPaths.add(lastPath);
            this.next = Suppliers.memoize(() -> this.computeNext(lastPath));
            return lastPath;
        }

        private Path<V, E> computeNext(Path<V, E> lastPath) {
            for (int i = 0; i < lastPath.edges().size(); ++i) {
                Object spurNode = ((Edge)lastPath.edges().get(i)).src();
                List rootPathEdgeList = lastPath.edges().subList(0, i);
                for (Path path : this.resultPaths) {
                    if (path.edges().size() < i || !rootPathEdgeList.equals(path.edges().subList(0, i))) continue;
                    this.maskingWeigher.excluded.add((Edge)path.edges().get(i));
                }
                rootPathEdgeList.forEach(edge -> {
                    this.maskingWeigher.excluded.addAll(this.graph.getEdgesFrom(edge.src()));
                    this.maskingWeigher.excluded.addAll(this.graph.getEdgesTo(edge.src()));
                });
                this.this$0.shortest.search(this.graph, spurNode, this.dst, this.maskingWeigher, 1).paths().stream().findAny().ifPresent(spurPath -> {
                    ImmutableList totalPath = ImmutableList.builder().addAll((Iterable)rootPathEdgeList).addAll(spurPath.edges()).build();
                    this.potentialPaths.add(this.path((List)totalPath));
                });
                this.maskingWeigher.excluded.clear();
            }
            if (this.potentialPaths.isEmpty()) {
                return null;
            }
            return this.potentialPaths.poll();
        }

        private Path<V, E> path(List<E> edges) {
            return new DefaultPath(edges, this.calculatePathCost(this.weigher, edges));
        }

        private Weight calculatePathCost(EdgeWeigher<V, E> weighter, List<E> edges) {
            Weight totalCost = weighter.getInitialWeight();
            for (Edge edge : edges) {
                totalCost = totalCost.merge(weighter.weight(edge));
            }
            return totalCost;
        }
    }
}

