/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduParameterSet;

public class EAPOLMkpduICVIndicatorParameterSet
extends BasePacket
implements EAPOLMkpduParameterSet {
    private byte[] icv;
    private short bodyLength;
    public static final short TOTAL_ICVPS_BODY_LENGTH = 20;

    @Override
    public byte[] serialize() {
        short length = this.getTotalLength();
        ByteBuffer data = ByteBuffer.wrap(new byte[length]);
        data.put((byte)-1);
        byte octet = 0;
        data.put(octet);
        length = (short)(length - 4);
        octet = (byte)(octet | (byte)(length >> 8 & 0xF));
        data.put(octet);
        data.put((byte)length);
        return data.array();
    }

    public static Deserializer<EAPOLMkpduICVIndicatorParameterSet> deserializer() {
        return (data, offset, length) -> {
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpduICVIndicatorParameterSet icvps = new EAPOLMkpduICVIndicatorParameterSet();
            byte[] mbField = new byte[2];
            bb.get(mbField, 0, 2);
            short bodyLength = (short)((short)(mbField[1] & 0xF) << 8);
            bodyLength = (short)(bodyLength | (short)bb.get());
            icvps.setBodyLength(bodyLength);
            byte[] icv = new byte[bodyLength];
            bb.get(icv);
            icvps.setICV(icv);
            return icvps;
        };
    }

    @Override
    public byte getParameterSetType() {
        return -1;
    }

    @Override
    public short getTotalLength() {
        return 20;
    }

    @Override
    public short getBodyLength() {
        return 16;
    }

    public void setBodyLength(short bodyLength) {
        this.bodyLength = bodyLength;
    }

    public void setICV(byte[] icv) {
        this.icv = icv;
    }
}

