/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.MoreObjects;

public class GeoLocation {
    public static final double EARTH_RADIUS_KM = 6378.137;
    private final double latitude;
    private final double longitude;

    public GeoLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double latitude() {
        return this.latitude;
    }

    public double longitude() {
        return this.longitude;
    }

    public double kilometersTo(GeoLocation other) {
        double hereLat = Math.toRadians(this.latitude);
        double hereLon = Math.toRadians(this.longitude);
        double thereLat = Math.toRadians(other.latitude);
        double thereLon = Math.toRadians(other.longitude);
        double cos = Math.sin(hereLat) * Math.sin(thereLat) + Math.cos(hereLat) * Math.cos(thereLat) * Math.cos(hereLon - thereLon);
        return Math.acos(cos) * 6378.137;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("latitude", this.latitude).add("longitude", this.longitude).toString();
    }
}

