/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.metrics.MetricsService;
import org.onlab.util.SharedExecutorService;
import org.onlab.util.Tools;

public final class SharedExecutors {
    public static final int DEFAULT_POOL_SIZE = 30;
    private static SharedExecutorService singleThreadExecutor;
    private static SharedExecutorService poolThreadExecutor;
    private static SharedTimer sharedTimer;
    private static final Object SHARED_TIMER_LOCK;

    private SharedExecutors() {
    }

    public static ExecutorService getSingleThreadExecutor() {
        SharedExecutors.setup();
        return singleThreadExecutor;
    }

    public static ExecutorService getPoolThreadExecutor() {
        SharedExecutors.setup();
        return poolThreadExecutor;
    }

    public static Timer getTimer() {
        SharedExecutors.setup();
        return sharedTimer;
    }

    public static void setPoolSize(int poolSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Shared pool size size must be greater than 0");
        poolThreadExecutor.setBackingExecutor(Executors.newFixedThreadPool(poolSize, Tools.groupedThreads("onos/shared", "onos-pool-executor-%d")));
    }

    public static void setMetricsService(MetricsService metricsService) {
        poolThreadExecutor.setMetricsService(metricsService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = SHARED_TIMER_LOCK;
        synchronized (object) {
            sharedTimer.shutdown();
            singleThreadExecutor.backingExecutor().shutdown();
            poolThreadExecutor.backingExecutor().shutdown();
            sharedTimer = null;
            singleThreadExecutor = null;
            poolThreadExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setup() {
        Object object = SHARED_TIMER_LOCK;
        synchronized (object) {
            if (sharedTimer == null) {
                sharedTimer = new SharedTimer();
                singleThreadExecutor = new SharedExecutorService(Executors.newSingleThreadExecutor(Tools.groupedThreads("onos/shared", "onos-single-executor")));
                poolThreadExecutor = new SharedExecutorService(Executors.newFixedThreadPool(30, Tools.groupedThreads("onos/shared", "onos-pool-executor-%d")));
            }
        }
    }

    static {
        SHARED_TIMER_LOCK = new Object();
    }

    private static class SharedTimer
    extends Timer {
        public SharedTimer() {
            super("onos-shared-timer");
        }

        @Override
        public void cancel() {
            throw new UnsupportedOperationException("Cancel of shared timer is not allowed");
        }

        private void shutdown() {
            super.cancel();
        }
    }
}

