/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.graph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.graph.Edge;
import org.onlab.graph.Vertex;

public abstract class AbstractEdge<V extends Vertex>
implements Edge<V> {
    private final V src;
    private final V dst;

    public AbstractEdge(V src, V dst) {
        this.src = (Vertex)Preconditions.checkNotNull(src, (Object)"Source vertex cannot be null");
        this.dst = (Vertex)Preconditions.checkNotNull(dst, (Object)"Destination vertex cannot be null");
    }

    @Override
    public V src() {
        return this.src;
    }

    @Override
    public V dst() {
        return this.dst;
    }

    public int hashCode() {
        return Objects.hash(this.src, this.dst);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractEdge) {
            AbstractEdge other = (AbstractEdge)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", this.src).add("dst", this.dst).toString();
    }
}

