/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.ipv6.EncapSecurityPayload;

public class EncapSecurityPayloadTest {
    private static Data data;
    private static byte[] dataByte;
    private static byte[] bytePacket;
    private Deserializer<EncapSecurityPayload> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Arrays.fill(dataByte, (byte)-1);
        data = new Data().setData(dataByte);
        byte[] bytePayload = data.serialize();
        byte[] byteHeader = new byte[]{19, 87, 36, 104, 0, -1, -1, 0};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = EncapSecurityPayload.deserializer();
    }

    @Test
    public void testSerialize() {
        EncapSecurityPayload esp = new EncapSecurityPayload();
        esp.setSecurityParamIndex(324478056);
        esp.setSequence(0xFFFF00);
        esp.setPayload((IPacket)data);
        Assert.assertArrayEquals((byte[])esp.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        EncapSecurityPayload esp = (EncapSecurityPayload)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)esp.getSecurityParamIndex(), (Matcher)Matchers.is((Object)324478056));
        Assert.assertThat((Object)esp.getSequence(), (Matcher)Matchers.is((Object)0xFFFF00));
    }

    @Test
    public void testEqual() {
        EncapSecurityPayload esp1 = new EncapSecurityPayload();
        esp1.setSecurityParamIndex(324478056);
        esp1.setSequence(0xFFFF00);
        EncapSecurityPayload esp2 = new EncapSecurityPayload();
        esp2.setSecurityParamIndex(324478056);
        esp2.setSequence(0xFFFFF0);
        Assert.assertTrue((boolean)esp1.equals((Object)esp1));
        Assert.assertFalse((boolean)esp1.equals((Object)esp2));
    }

    @Test
    public void testToStringESP() throws Exception {
        EncapSecurityPayload esp = (EncapSecurityPayload)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = esp.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"securityParamIndex=324478056"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"sequence=16776960"));
    }

    static {
        dataByte = new byte[32];
    }
}

