/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.ArrayUtils;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ethernet;
import org.onlab.packet.LLDP;
import org.onlab.packet.LLDPOrganizationalTLV;
import org.onlab.packet.LLDPTLV;
import org.onlab.packet.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ONOSLLDP
extends LLDP {
    private static final Logger log = LoggerFactory.getLogger(ONOSLLDP.class);
    public static final String DEFAULT_DEVICE = "INVALID";
    public static final String DEFAULT_NAME = "ONOS Discovery";
    protected static final byte NAME_SUBTYPE = 1;
    protected static final byte DEVICE_SUBTYPE = 2;
    protected static final byte DOMAIN_SUBTYPE = 3;
    protected static final byte TIMESTAMP_SUBTYPE = 4;
    protected static final byte SIG_SUBTYPE = 5;
    private static final short NAME_LENGTH = 4;
    private static final short DEVICE_LENGTH = 4;
    private static final short DOMAIN_LENGTH = 4;
    private static final short TIMESTAMP_LENGTH = 4;
    private static final short SIG_LENGTH = 4;
    private final HashMap<Byte, LLDPOrganizationalTLV> opttlvs = Maps.newHashMap();
    private static final byte CHASSIS_TLV_TYPE = 1;
    private static final byte CHASSIS_TLV_SIZE = 7;
    private static final byte CHASSIS_TLV_SUBTYPE = 4;
    private static final byte TTL_TLV_TYPE = 3;
    private static final byte PORT_DESC_TLV_TYPE = 4;
    private final byte[] ttlValue = new byte[]{0, 120};

    public ONOSLLDP(byte ... subtype) {
        for (byte st : subtype) {
            this.opttlvs.put(st, new LLDPOrganizationalTLV());
        }
        this.opttlvs.putIfAbsent((byte)1, new LLDPOrganizationalTLV());
        this.opttlvs.putIfAbsent((byte)2, new LLDPOrganizationalTLV());
        this.setName(DEFAULT_NAME);
        this.setDevice(DEFAULT_DEVICE);
        this.setOptionalTLVList(Lists.newArrayList(this.opttlvs.values()));
        this.setTtl(new LLDPTLV().setType((byte)3).setLength((short)this.ttlValue.length).setValue(this.ttlValue));
    }

    private ONOSLLDP(LLDP lldp) {
        this.portId = lldp.getPortId();
        this.chassisId = lldp.getChassisId();
        this.ttl = lldp.getTtl();
        this.optionalTLVList = lldp.getOptionalTLVList();
    }

    public void setName(String name) {
        LLDPOrganizationalTLV nametlv = this.opttlvs.get((byte)1);
        nametlv.setLength((short)(name.length() + 4));
        nametlv.setInfoString(name);
        nametlv.setSubType((byte)1);
        nametlv.setOUI(MacAddress.ONOS.oui());
    }

    public void setDevice(String device) {
        LLDPOrganizationalTLV devicetlv = this.opttlvs.get((byte)2);
        devicetlv.setInfoString(device);
        devicetlv.setLength((short)(device.length() + 4));
        devicetlv.setSubType((byte)2);
        devicetlv.setOUI(MacAddress.ONOS.oui());
    }

    public void setDomainInfo(String domainId) {
        LLDPOrganizationalTLV domaintlv = this.opttlvs.get((byte)3);
        if (domaintlv == null) {
            return;
        }
        domaintlv.setInfoString(domainId);
        domaintlv.setLength((short)(domainId.length() + 4));
        domaintlv.setSubType((byte)3);
        domaintlv.setOUI(MacAddress.ONOS.oui());
    }

    public void setChassisId(ChassisId chassisId) {
        MacAddress chassisMac = MacAddress.valueOf(chassisId.value());
        byte[] chassis = ArrayUtils.addAll((byte[])new byte[]{4}, (byte[])chassisMac.toBytes());
        LLDPTLV chassisTLV = new LLDPTLV();
        chassisTLV.setLength((short)7);
        chassisTLV.setType((byte)1);
        chassisTLV.setValue(chassis);
        this.setChassisId(chassisTLV);
    }

    public void setPortId(int portNumber) {
        byte[] port = ArrayUtils.addAll((byte[])new byte[]{2}, (byte[])String.valueOf(portNumber).getBytes(StandardCharsets.UTF_8));
        LLDPTLV portTLV = new LLDPTLV();
        portTLV.setLength((short)port.length);
        portTLV.setType((byte)2);
        portTLV.setValue(port);
        this.setPortId(portTLV);
    }

    public void setPortName(String portName) {
        byte[] port = ArrayUtils.addAll((byte[])new byte[]{5}, (byte[])portName.getBytes(StandardCharsets.UTF_8));
        LLDPTLV portTLV = new LLDPTLV();
        portTLV.setLength((short)port.length);
        portTLV.setType((byte)2);
        portTLV.setValue(port);
        this.setPortId(portTLV);
    }

    public void setTimestamp(long timestamp) {
        LLDPOrganizationalTLV tmtlv = this.opttlvs.get((byte)4);
        if (tmtlv == null) {
            return;
        }
        tmtlv.setInfoString(ByteBuffer.allocate(8).putLong(timestamp).array());
        tmtlv.setLength((short)12);
        tmtlv.setSubType((byte)4);
        tmtlv.setOUI(MacAddress.ONOS.oui());
    }

    public void setSig(byte[] sig) {
        LLDPOrganizationalTLV sigtlv = this.opttlvs.get((byte)5);
        if (sigtlv == null) {
            return;
        }
        sigtlv.setInfoString(sig);
        sigtlv.setLength((short)(sig.length + 4));
        sigtlv.setSubType((byte)5);
        sigtlv.setOUI(MacAddress.ONOS.oui());
    }

    public LLDPOrganizationalTLV getNameTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 1) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getDeviceTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 2) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getTimestampTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 4) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getSigTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 5) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPOrganizationalTLV getDomainTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            LLDPOrganizationalTLV orgTLV;
            if (tlv.getType() != 127 || (orgTLV = (LLDPOrganizationalTLV)tlv).getSubType() != 3) continue;
            return orgTLV;
        }
        return null;
    }

    public LLDPTLV getPortDescTLV() {
        for (LLDPTLV tlv : this.getOptionalTLVList()) {
            if (tlv.getType() != 4) continue;
            return tlv;
        }
        log.debug("Cannot find the port description tlv type.");
        return null;
    }

    public String getNameString() {
        LLDPOrganizationalTLV tlv = this.getNameTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getDeviceString() {
        LLDPOrganizationalTLV tlv = this.getDeviceTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getDomainString() {
        LLDPOrganizationalTLV tlv = this.getDomainTLV();
        if (tlv != null) {
            return new String(tlv.getInfoString(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public String getPortDescString() {
        LLDPTLV tlv = this.getPortDescTLV();
        if (tlv != null) {
            return new String(tlv.getValue(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public Integer getPort() {
        ByteBuffer portBB = ByteBuffer.wrap(this.getPortId().getValue());
        byte type = portBB.get();
        if (type == 2) {
            return Integer.parseInt(new String(portBB.array(), portBB.position(), portBB.remaining(), StandardCharsets.UTF_8));
        }
        return -1;
    }

    public String getPortNameString() {
        ByteBuffer portBB = ByteBuffer.wrap(this.getPortId().getValue());
        byte type = portBB.get();
        if (type == 5) {
            return new String(portBB.array(), portBB.position(), portBB.remaining(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public MacAddress getChassisIdByMac() {
        ByteBuffer portBB = ByteBuffer.wrap(this.getChassisId().getValue());
        byte type = portBB.get();
        if (type == 4) {
            byte[] bytes = new byte[portBB.remaining()];
            System.arraycopy(portBB.array(), portBB.position(), bytes, 0, 6);
            return new MacAddress(bytes);
        }
        return MacAddress.NONE;
    }

    public short getTtlBySeconds() {
        ByteBuffer portBB = ByteBuffer.wrap(this.getTtl().getValue());
        return portBB.getShort();
    }

    public long getTimestamp() {
        LLDPOrganizationalTLV tlv = this.getTimestampTLV();
        if (tlv != null) {
            ByteBuffer b = ByteBuffer.allocate(8).put(tlv.getInfoString());
            b.flip();
            return b.getLong();
        }
        return 0L;
    }

    public byte[] getSig() {
        LLDPOrganizationalTLV tlv = this.getSigTLV();
        if (tlv != null) {
            return tlv.getInfoString();
        }
        return null;
    }

    public static ONOSLLDP parseONOSLLDP(Ethernet eth) {
        ONOSLLDP onosLldp;
        if ((eth.getEtherType() == Ethernet.TYPE_LLDP || eth.getEtherType() == Ethernet.TYPE_BSN) && DEFAULT_NAME.equals((onosLldp = new ONOSLLDP((LLDP)eth.getPayload())).getNameString())) {
            return onosLldp;
        }
        return null;
    }

    public static ONOSLLDP parseLLDP(Ethernet eth) {
        if (eth.getEtherType() == Ethernet.TYPE_LLDP || eth.getEtherType() == Ethernet.TYPE_BSN) {
            return new ONOSLLDP((LLDP)eth.getPayload());
        }
        log.error("Packet is not the LLDP or BSN.");
        return null;
    }

    @Deprecated
    public static ONOSLLDP onosLLDP(String deviceId, ChassisId chassisId, int portNum) {
        ONOSLLDP probe = new ONOSLLDP(1, 2);
        probe.setPortId(portNum);
        probe.setDevice(deviceId);
        probe.setChassisId(chassisId);
        return probe;
    }

    public static ONOSLLDP onosSecureLLDP(String deviceId, ChassisId chassisId, int portNum, String secret) {
        ONOSLLDP probe = null;
        probe = secret == null ? new ONOSLLDP(1, 2) : new ONOSLLDP(1, 2, 4, 5);
        probe.setPortId(portNum);
        probe.setDevice(deviceId);
        probe.setChassisId(chassisId);
        if (secret != null) {
            long ts = System.currentTimeMillis();
            probe.setTimestamp(ts);
            byte[] sig = ONOSLLDP.createSig(deviceId, portNum, ts, secret);
            if (sig == null) {
                return null;
            }
            probe.setSig(sig);
            sig = null;
        }
        return probe;
    }

    @Deprecated
    public static ONOSLLDP onosLLDP(String deviceId, ChassisId chassisId, int portNum, String portDesc) {
        ONOSLLDP probe = ONOSLLDP.onosLLDP(deviceId, chassisId, portNum);
        ONOSLLDP.addPortDesc(probe, portDesc);
        return probe;
    }

    public static ONOSLLDP onosSecureLLDP(String deviceId, ChassisId chassisId, int portNum, String portDesc, String secret) {
        ONOSLLDP probe = ONOSLLDP.onosSecureLLDP(deviceId, chassisId, portNum, secret);
        ONOSLLDP.addPortDesc(probe, portDesc);
        return probe;
    }

    private static void addPortDesc(ONOSLLDP probe, String portDesc) {
        if (portDesc != null && !portDesc.isEmpty()) {
            byte[] bPortDesc = portDesc.getBytes(StandardCharsets.UTF_8);
            if (bPortDesc.length > 511) {
                bPortDesc = Arrays.copyOf(bPortDesc, 511);
            }
            LLDPTLV portDescTlv = new LLDPTLV().setType((byte)4).setLength((short)bPortDesc.length).setValue(bPortDesc);
            probe.addOptionalTLV(portDescTlv);
        }
    }

    private static byte[] createSig(String deviceId, int portNum, long timestamp, String secret) {
        byte[] pnb = ByteBuffer.allocate(8).putLong(portNum).array();
        byte[] tmb = ByteBuffer.allocate(8).putLong(timestamp).array();
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            mac.update(deviceId.getBytes());
            mac.update(pnb);
            mac.update(tmb);
            byte[] sig = mac.doFinal();
            return sig;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (InvalidKeyException e) {
            return null;
        }
    }

    private static boolean verifySig(byte[] sig, String deviceId, int portNum, long timestamp, String secret) {
        byte[] nsig = ONOSLLDP.createSig(deviceId, portNum, timestamp, secret);
        if (nsig == null) {
            return false;
        }
        if (!ArrayUtils.isSameLength((byte[])nsig, (byte[])sig)) {
            return false;
        }
        boolean fail = false;
        for (int i = 0; i < nsig.length; ++i) {
            if (sig[i] == nsig[i]) continue;
            fail = true;
        }
        return !fail;
    }

    public static boolean verify(ONOSLLDP probe, String secret, long maxDelay) {
        if (secret == null) {
            return true;
        }
        String deviceId = probe.getDeviceString();
        int portNum = probe.getPort();
        long timestamp = probe.getTimestamp();
        byte[] sig = probe.getSig();
        if (deviceId == null || sig == null) {
            return false;
        }
        if (timestamp + maxDelay <= System.currentTimeMillis() || timestamp > System.currentTimeMillis()) {
            return false;
        }
        return ONOSLLDP.verifySig(sig, deviceId, portNum, timestamp, secret);
    }
}

