/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ip4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIPV2Entry
extends BasePacket {
    public static final int ENTRY_LEN = 20;
    public static final short AFI_IP = 2;
    public static final byte INFINITY_METRIC = 16;
    public static final byte NEXTHOP_METRIC = -128;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected short addressFamilyId;
    protected short routeTag;
    protected Ip4Address ipAddress;
    protected Ip4Address subnetMask;
    protected Ip4Address nextHop;
    protected int metric;

    @Override
    public byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putShort(this.addressFamilyId);
        byteBuffer.putShort(this.routeTag);
        byteBuffer.putInt(this.ipAddress.toInt());
        byteBuffer.putInt(this.subnetMask.toInt());
        byteBuffer.putInt(this.nextHop.toInt());
        byteBuffer.putInt(this.metric);
        return byteBuffer.array();
    }

    public static Deserializer<RIPV2Entry> deserializer() {
        return (data, offset, length) -> {
            RIPV2Entry ripEntry = new RIPV2Entry();
            Preconditions.checkNotNull((Object)data);
            if (offset < 0 || length < 0 || length > data.length || offset >= data.length || offset + length > data.length) {
                throw new DeserializationException("Illegal offset or length");
            }
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            if (bb.remaining() < 20) {
                throw new DeserializationException("Buffer underflow while reading RIP entry");
            }
            ripEntry.addressFamilyId = bb.getShort();
            if (ripEntry.addressFamilyId == 65535) {
                return ripEntry;
            }
            ripEntry.routeTag = bb.getShort();
            ripEntry.ipAddress = Ip4Address.valueOf(bb.getInt());
            ripEntry.subnetMask = Ip4Address.valueOf(bb.getInt());
            ripEntry.nextHop = Ip4Address.valueOf(bb.getInt());
            ripEntry.metric = bb.getInt();
            return ripEntry;
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextHop.toInt(), this.subnetMask.toInt(), this.ipAddress.toInt(), this.addressFamilyId, this.metric, this.routeTag);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RIPV2Entry)) {
            return false;
        }
        RIPV2Entry that = (RIPV2Entry)obj;
        return super.equals(that) && Objects.equals(this.routeTag, that.routeTag) && Objects.equals(this.metric, that.metric) && Objects.equals(this.addressFamilyId, that.addressFamilyId) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.nextHop, that.nextHop) && Objects.equals(this.subnetMask, that.subnetMask);
    }

    public short getAddressFamilyId() {
        return this.addressFamilyId;
    }

    public RIPV2Entry setAddressFamilyId(short addressFamilyIdentifier) {
        this.addressFamilyId = addressFamilyIdentifier;
        return this;
    }

    public short getRouteTag() {
        return this.routeTag;
    }

    public RIPV2Entry setRouteTag(short routetag) {
        this.routeTag = routetag;
        return this;
    }

    public Ip4Address getipAddress() {
        return this.ipAddress;
    }

    public RIPV2Entry setIpAddress(Ip4Address ipaddress) {
        this.ipAddress = ipaddress;
        return this;
    }

    public Ip4Address getSubnetMask() {
        return this.subnetMask;
    }

    public RIPV2Entry setSubnetMask(Ip4Address subnetmask) {
        this.subnetMask = subnetmask;
        return this;
    }

    public Ip4Address getNextHop() {
        return this.nextHop;
    }

    public RIPV2Entry setNextHop(Ip4Address nexthop) {
        this.nextHop = nexthop;
        return this;
    }

    public int getMetric() {
        return this.metric;
    }

    public RIPV2Entry setMetric(int metric) {
        this.metric = metric;
        return this;
    }

    public String toString() {
        return "RIPV2Entry [address family Id=" + this.addressFamilyId + ", route tag=" + this.routeTag + ", Address=" + this.ipAddress + ", Subnet mask=" + this.subnetMask + ", Mext hop=" + this.nextHop + ", metric = " + this.metric + "]";
    }
}

