/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SafeRecurringTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SafeRecurringTask.class);
    private final Runnable runnable;

    private SafeRecurringTask(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        if (Thread.currentThread().isInterrupted()) {
            log.info("Task interrupted, quitting");
            return;
        }
        try {
            this.runnable.run();
        }
        catch (Exception e) {
            log.error("Exception thrown during task", (Throwable)e);
        }
    }

    public static SafeRecurringTask wrap(Runnable runnable) {
        return new SafeRecurringTask(runnable);
    }
}

