/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.dhcp;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.DHCP6;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.dhcp.Dhcp6Option;

public final class Dhcp6CLTOption
extends Dhcp6Option {
    public static final int DEFAULT_LEN = 4;
    private int clt;

    @Override
    public short getCode() {
        return DHCP6.OptionCode.CLIENT_LT.value();
    }

    @Override
    public short getLength() {
        return 4;
    }

    public int getClt() {
        return this.clt;
    }

    public void setClt(int clt) {
        this.clt = clt;
    }

    public Dhcp6CLTOption() {
    }

    public Dhcp6CLTOption(Dhcp6Option dhcp6Option) {
        super(dhcp6Option);
    }

    public static Deserializer<Dhcp6Option> deserializer() {
        return (data, offset, length) -> {
            Dhcp6Option dhcp6Option = Dhcp6Option.deserializer().deserialize(data, offset, length);
            if (dhcp6Option.getLength() < 4) {
                throw new DeserializationException("Invalid CLT option data");
            }
            Dhcp6CLTOption cltOption = new Dhcp6CLTOption(dhcp6Option);
            byte[] optionData = cltOption.getData();
            ByteBuffer bb = ByteBuffer.wrap(optionData);
            cltOption.clt = bb.getInt();
            return cltOption;
        };
    }

    @Override
    public byte[] serialize() {
        int payloadLen = 4;
        int len = 4 + payloadLen;
        ByteBuffer bb = ByteBuffer.allocate(len);
        bb.putShort(DHCP6.OptionCode.CLIENT_LT.value());
        bb.putShort((short)payloadLen);
        bb.putInt(this.clt);
        return bb.array();
    }

    @Override
    public String toString() {
        return this.getToStringHelper().add("clt", this.clt).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clt);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dhcp6CLTOption)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Dhcp6CLTOption other = (Dhcp6CLTOption)obj;
        return Objects.equals(this.getCode(), other.getCode()) && Objects.equals(this.getLength(), other.getLength()) && Objects.equals(this.clt, other.clt);
    }
}

