/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.MacAddress;

public class MacAddressTest {
    private static final MacAddress MAC_NORMAL = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private static final MacAddress MAC_BCAST = MacAddress.valueOf((String)"ff:ff:ff:ff:ff:ff");
    private static final MacAddress MAC_MCAST = MacAddress.valueOf((String)"01:00:5e:00:00:00");
    private static final MacAddress MAC_MCAST_2 = MacAddress.valueOf((String)"01:00:0c:cc:cc:cc");
    private static final MacAddress MAC_LLDP = MacAddress.valueOf((String)"01:80:c2:00:00:00");
    private static final MacAddress MAC_LLDP_2 = MacAddress.valueOf((String)"01:80:c2:00:00:03");
    private static final MacAddress MAC_LLDP_3 = MacAddress.valueOf((String)"01:80:c2:00:00:0e");
    private static final MacAddress MAC_ONOS = MacAddress.valueOf((String)"a4:23:05:01:02:03");
    private static final MacAddress MAC_ONOS_EQUAL = MacAddress.valueOf((String)"a4:23:05:01:02:03");
    private static final byte[] OUI_ONOS = new byte[]{-92, 35, 5};
    private static final byte[] MAC_ONOS_BYTE = new byte[]{-92, 35, 5, 1, 2, 3};
    private static final long MAC_ONOS_LONG = 180470314762755L;
    private static final String MAC_ONOS_STR = "A4:23:05:01:02:03";
    private static final String MAC_ONOS_STR_NO_COLON = "A42305010203";
    private static final int LENGTH = 6;
    private static final String INVALID_STR = "invalid";
    private static final byte[] INVALID_BYTE = new byte[]{-86};
    private static final String INVALID_MAC_ADDITIONAL_COLON = "00:00:00:00:00:00:";
    private static final String INVALID_MAC_OCTET_TOO_LONG = "000:000:000:000:000:00";
    private static final String INVALID_MAC_OCTET_TOO_SHORT = "00:0:00:00:00:00";

    @Test
    public void testValueOfString() throws Exception {
        Assert.assertArrayEquals((byte[])MAC_ONOS_BYTE, (byte[])MacAddress.valueOf((String)MAC_ONOS_STR).toBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfInvalidString() throws Exception {
        MacAddress.valueOf((String)INVALID_STR);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfInvalidStringWithAdditionalColon() throws Exception {
        MacAddress.valueOf((String)INVALID_MAC_ADDITIONAL_COLON);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfInvalidStringWithTooLongOctet() throws Exception {
        MacAddress.valueOf((String)INVALID_MAC_OCTET_TOO_LONG);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfInvalidStringWithTooShortOctet() throws Exception {
        MacAddress.valueOf((String)INVALID_MAC_OCTET_TOO_SHORT);
    }

    @Test
    public void testValueOfByte() throws Exception {
        Assert.assertArrayEquals((byte[])MAC_ONOS_BYTE, (byte[])MacAddress.valueOf((byte[])MAC_ONOS_BYTE).toBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValueOfInvalidByte() throws Exception {
        MacAddress.valueOf((byte[])INVALID_BYTE);
    }

    @Test
    public void testValueOfLong() throws Exception {
        Assert.assertArrayEquals((byte[])MAC_ONOS_BYTE, (byte[])MacAddress.valueOf((long)180470314762755L).toBytes());
    }

    @Test
    public void testLength() throws Exception {
        Assert.assertEquals((long)6L, (long)MAC_NORMAL.length());
    }

    @Test
    public void testToBytes() throws Exception {
        Assert.assertArrayEquals((byte[])MAC_ONOS_BYTE, (byte[])MAC_ONOS.toBytes());
    }

    @Test
    public void testToLong() throws Exception {
        Assert.assertEquals((long)180470314762755L, (long)MAC_ONOS.toLong());
    }

    @Test
    public void testIsBroadcast() throws Exception {
        Assert.assertFalse((boolean)MAC_NORMAL.isBroadcast());
        Assert.assertTrue((boolean)MAC_BCAST.isBroadcast());
        Assert.assertFalse((boolean)MAC_MCAST.isBroadcast());
        Assert.assertFalse((boolean)MAC_MCAST_2.isBroadcast());
        Assert.assertFalse((boolean)MAC_LLDP.isBroadcast());
        Assert.assertFalse((boolean)MAC_LLDP_2.isBroadcast());
        Assert.assertFalse((boolean)MAC_LLDP_3.isBroadcast());
        Assert.assertFalse((boolean)MAC_ONOS.isBroadcast());
    }

    @Test
    public void testIsMulticast() throws Exception {
        Assert.assertFalse((boolean)MAC_NORMAL.isMulticast());
        Assert.assertFalse((boolean)MAC_BCAST.isMulticast());
        Assert.assertTrue((boolean)MAC_MCAST.isMulticast());
        Assert.assertTrue((boolean)MAC_MCAST_2.isMulticast());
        Assert.assertTrue((boolean)MAC_LLDP.isMulticast());
        Assert.assertTrue((boolean)MAC_LLDP_2.isMulticast());
        Assert.assertTrue((boolean)MAC_LLDP_3.isMulticast());
        Assert.assertFalse((boolean)MAC_ONOS.isMulticast());
    }

    @Test
    public void testIsLldp() throws Exception {
        Assert.assertFalse((boolean)MAC_NORMAL.isLldp());
        Assert.assertFalse((boolean)MAC_BCAST.isLldp());
        Assert.assertFalse((boolean)MAC_MCAST.isLldp());
        Assert.assertFalse((boolean)MAC_MCAST_2.isLldp());
        Assert.assertTrue((boolean)MAC_LLDP.isLldp());
        Assert.assertTrue((boolean)MAC_LLDP_2.isLldp());
        Assert.assertTrue((boolean)MAC_LLDP_3.isLldp());
        Assert.assertFalse((boolean)MAC_ONOS.isLldp());
    }

    @Test
    public void testIsOnos() throws Exception {
        Assert.assertFalse((boolean)MAC_NORMAL.isOnos());
        Assert.assertFalse((boolean)MAC_BCAST.isOnos());
        Assert.assertFalse((boolean)MAC_MCAST.isOnos());
        Assert.assertFalse((boolean)MAC_MCAST_2.isOnos());
        Assert.assertFalse((boolean)MAC_LLDP.isOnos());
        Assert.assertFalse((boolean)MAC_LLDP_2.isOnos());
        Assert.assertFalse((boolean)MAC_LLDP_3.isOnos());
        Assert.assertTrue((boolean)MAC_ONOS.isOnos());
    }

    @Test
    public void testOui() throws Exception {
        Assert.assertArrayEquals((byte[])MAC_ONOS.oui(), (byte[])OUI_ONOS);
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertTrue((boolean)MAC_ONOS.equals((Object)MAC_ONOS));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_ONOS_STR));
        Assert.assertTrue((boolean)MAC_ONOS.equals((Object)MAC_ONOS_EQUAL));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_NORMAL));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_BCAST));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_MCAST));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_MCAST_2));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_LLDP));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_LLDP_2));
        Assert.assertFalse((boolean)MAC_ONOS.equals((Object)MAC_LLDP_3));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)Long.hashCode(180470314762755L), (long)MAC_ONOS.hashCode());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)MAC_ONOS_STR, (Object)MAC_ONOS.toString());
    }

    @Test
    public void testToStringNoColon() throws Exception {
        Assert.assertEquals((Object)MAC_ONOS_STR_NO_COLON, (Object)MAC_ONOS.toStringNoColon());
    }
}

