/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Data;
import org.onlab.packet.Deserializer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMPEcho;
import org.onlab.packet.IPv4;
import org.onlab.packet.PacketUtils;

public class ICMP
extends BasePacket {
    protected byte icmpType;
    protected byte icmpCode;
    protected short checksum;
    public static final byte TYPE_ECHO_REQUEST = 8;
    public static final byte TYPE_ECHO_REPLY = 0;
    public static final byte CODE_ECHO_REPLY = 0;
    public static final byte CODE_ECHO_REQEUST = 0;
    public static final short ICMP_HEADER_LENGTH = 4;

    public byte getIcmpType() {
        return this.icmpType;
    }

    public ICMP setIcmpType(byte icmpType) {
        this.icmpType = icmpType;
        return this;
    }

    public byte getIcmpCode() {
        return this.icmpCode;
    }

    public ICMP setIcmpCode(byte icmpCode) {
        this.icmpCode = icmpCode;
        return this;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public ICMP setChecksum(short checksum) {
        this.checksum = checksum;
        return this;
    }

    @Override
    public byte[] serialize() {
        int length = 4;
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
            length += payloadData.length;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.icmpType);
        bb.put(this.icmpCode);
        bb.putShort(this.checksum);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        if (this.parent != null && this.parent instanceof IPv4) {
            ((IPv4)this.parent).setProtocol((byte)1);
        }
        if (this.checksum == 0) {
            bb.rewind();
            int accumulation = 0;
            for (int i = 0; i < length / 2; ++i) {
                accumulation += 0xFFFF & bb.getShort();
            }
            if (length % 2 > 0) {
                accumulation += (bb.get() & 0xFF) << 8;
            }
            accumulation = (accumulation >> 16 & 0xFFFF) + (accumulation & 0xFFFF);
            this.checksum = (short)(~accumulation & 0xFFFF);
            bb.putShort(2, this.checksum);
        }
        return data;
    }

    @Override
    public int hashCode() {
        int prime = 5807;
        int result = super.hashCode();
        result = 5807 * result + this.icmpType;
        result = 5807 * result + this.icmpCode;
        result = 5807 * result + this.checksum;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ICMP)) {
            return false;
        }
        ICMP other = (ICMP)obj;
        if (this.icmpType != other.icmpType) {
            return false;
        }
        if (this.icmpCode != other.icmpCode) {
            return false;
        }
        return this.checksum == other.checksum;
    }

    public static Deserializer<ICMP> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 4);
            ICMP icmp = new ICMP();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            icmp.icmpType = bb.get();
            icmp.icmpCode = bb.get();
            icmp.checksum = bb.getShort();
            switch (icmp.icmpType) {
                case 0: 
                case 8: {
                    Deserializer<ICMPEcho> deserializer = ICMPEcho.deserializer();
                    icmp.payload = deserializer.deserialize(data, bb.position(), 4);
                    bb.position(bb.position() + 4);
                    icmp.payload.setPayload(Data.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position()));
                    break;
                }
                default: {
                    icmp.payload = Data.deserializer().deserialize(data, bb.position(), bb.limit() - bb.position());
                }
            }
            icmp.payload.setParent(icmp);
            return icmp;
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("icmpType", (Object)Byte.toString(this.icmpType)).add("icmpCode", (Object)Byte.toString(this.icmpCode)).add("checksum", (Object)Short.toString(this.checksum)).toString();
    }

    public static Ethernet buildIcmpReply(Ethernet ethRequest) {
        if (ethRequest.getEtherType() != Ethernet.TYPE_IPV4) {
            return null;
        }
        IPv4 ipRequest = (IPv4)ethRequest.getPayload();
        if (ipRequest.getProtocol() != 1) {
            return null;
        }
        Ethernet ethReply = new Ethernet();
        IPv4 ipReply = new IPv4();
        int destAddress = ipRequest.getDestinationAddress();
        ipReply.setDestinationAddress(ipRequest.getSourceAddress());
        ipReply.setSourceAddress(destAddress);
        ipReply.setTtl((byte)64);
        ipReply.setDiffServ(ipRequest.getDiffServ());
        ipReply.setChecksum((short)0);
        ipReply.setProtocol((byte)1);
        ICMP icmpRequest = (ICMP)ipRequest.getPayload();
        ICMP icmpReply = new ICMP();
        icmpReply.setPayload(icmpRequest.getPayload());
        icmpReply.setIcmpType((byte)0);
        icmpReply.setIcmpCode((byte)0);
        icmpReply.setChecksum((short)0);
        ipReply.setPayload(icmpReply);
        ethReply.setEtherType(Ethernet.TYPE_IPV4);
        ethReply.setQinQVID(ethRequest.getQinQVID());
        ethReply.setQinQTPID(ethRequest.getQinQTPID());
        ethReply.setVlanID(ethRequest.getVlanID());
        ethReply.setDestinationMACAddress(ethRequest.getSourceMACAddress());
        ethReply.setSourceMACAddress(ethRequest.getDestinationMACAddress());
        ethReply.setPayload(ipReply);
        return ethReply;
    }
}

