/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPv4;
import org.onlab.packet.PacketTestUtils;

public class IPv4Test {
    private static Deserializer<IPv4> deserializer;
    private static final byte VERSION = 4;
    private static final byte HEADER_LENGTH = 6;
    private static final byte DIFF_SERV = 2;
    private static final short TOTAL_LENGTH = 60;
    private static final short IDENTIFICATION = 1;
    private static final byte FLAGS = 1;
    private static final short FRAGMENT_OFFSET = 1;
    private static final byte TTL = 60;
    private static final byte PROTOCOL = 4;
    private static final short CHECKSUM = 4;
    private static final int SOURCE_ADDRESS = 1;
    private static final int DESTINATION_ADDRESS = 2;
    private static final byte[] OPTIONS;
    private byte[] headerBytes;

    @Before
    public void setUp() throws Exception {
        deserializer = IPv4.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(24);
        bb.put((byte)70);
        bb.put((byte)2);
        bb.putShort((short)60);
        bb.putShort((short)1);
        bb.putShort((short)8193);
        bb.put((byte)60);
        bb.put((byte)4);
        bb.putShort((short)4);
        bb.putInt(1);
        bb.putInt(2);
        bb.put(OPTIONS);
        this.headerBytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(deserializer, this.headerBytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        IPv4 ipv4 = (IPv4)deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        Assert.assertEquals((long)4L, (long)ipv4.getVersion());
        Assert.assertEquals((long)6L, (long)ipv4.getHeaderLength());
        Assert.assertEquals((long)2L, (long)ipv4.getDiffServ());
        Assert.assertEquals((long)60L, (long)ipv4.getTotalLength());
        Assert.assertEquals((long)1L, (long)ipv4.getIdentification());
        Assert.assertEquals((long)1L, (long)ipv4.getFlags());
        Assert.assertEquals((long)1L, (long)ipv4.getFragmentOffset());
        Assert.assertEquals((long)60L, (long)ipv4.getTtl());
        Assert.assertEquals((long)4L, (long)ipv4.getProtocol());
        Assert.assertEquals((long)4L, (long)ipv4.getChecksum());
        Assert.assertEquals((long)1L, (long)ipv4.getSourceAddress());
        Assert.assertEquals((long)2L, (long)ipv4.getDestinationAddress());
        Assert.assertTrue((boolean)ipv4.isTruncated());
    }

    @Test
    public void testToStringIPv4() throws Exception {
        IPv4 ipv4 = (IPv4)deserializer.deserialize(this.headerBytes, 0, this.headerBytes.length);
        String str = ipv4.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"version=4"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"headerLength=6"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"diffServ=2"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"totalLength=60"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"identification=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"flags=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"fragmentOffset=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"ttl=60"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"protocol=4"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"checksum=4"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"sourceAddress=1"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"destinationAddress=2"));
    }

    static {
        OPTIONS = new byte[]{1, 2, 3, 4};
    }
}

