/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.ipv6;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.UDP;
import org.onlab.packet.ipv6.Routing;

public class RoutingTest {
    private static Data data;
    private static UDP udp;
    private static byte[] routingData;
    private static byte[] bytePacket;
    private Deserializer<Routing> deserializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        data = new Data();
        data.setData("testSerialize".getBytes());
        udp = new UDP();
        udp.setPayload((IPacket)data);
        byte[] bytePayload = udp.serialize();
        byte[] byteHeader = new byte[]{17, 2, 0, 3, 0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
        bytePacket = new byte[byteHeader.length + bytePayload.length];
        System.arraycopy(byteHeader, 0, bytePacket, 0, byteHeader.length);
        System.arraycopy(bytePayload, 0, bytePacket, byteHeader.length, bytePayload.length);
    }

    @Before
    public void setUp() {
        this.deserializer = Routing.deserializer();
    }

    @Test
    public void testSerialize() {
        Routing routing = new Routing();
        routing.setNextHeader((byte)17);
        routing.setHeaderExtLength((byte)2);
        routing.setRoutingType((byte)0);
        routing.setSegmntsLeft((byte)3);
        routing.setRoutingData(routingData);
        routing.setPayload((IPacket)udp);
        Assert.assertArrayEquals((byte[])routing.serialize(), (byte[])bytePacket);
    }

    @Test
    public void testDeserialize() throws DeserializationException {
        Routing routing = (Routing)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        Assert.assertThat((Object)routing.getNextHeader(), (Matcher)Matchers.is((Object)17));
        Assert.assertThat((Object)routing.getHeaderExtLength(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)routing.getRoutingType(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)routing.getSegmentsLeft(), (Matcher)Matchers.is((Object)3));
        Assert.assertArrayEquals((byte[])routing.getRoutingData(), (byte[])routingData);
    }

    @Test
    public void testEqual() {
        Routing routing1 = new Routing();
        routing1.setNextHeader((byte)17);
        routing1.setHeaderExtLength((byte)2);
        routing1.setRoutingType((byte)0);
        routing1.setSegmntsLeft((byte)3);
        routing1.setRoutingData(routingData);
        Routing routing2 = new Routing();
        routing2.setNextHeader((byte)17);
        routing2.setHeaderExtLength((byte)2);
        routing2.setRoutingType((byte)0);
        routing2.setSegmntsLeft((byte)2);
        routing2.setRoutingData(routingData);
        Assert.assertTrue((boolean)routing1.equals((Object)routing1));
        Assert.assertFalse((boolean)routing1.equals((Object)routing2));
    }

    @Test
    public void testToStringRouting() throws Exception {
        Routing routing = (Routing)this.deserializer.deserialize(bytePacket, 0, bytePacket.length);
        String str = routing.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"nextHeader=17"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"headerExtLength=2"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"routingType=0"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)"segmentsLeft=3"));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("routingData=" + Arrays.toString(routingData))));
    }

    static {
        routingData = new byte[]{0, 0, 0, 0, 32, 1, 15, 24, 1, 19, 2, 21, -54, 42, 20, -1, -2, 53, 38, -50};
    }
}

