/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.io.Resources;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onlab.packet.lacp.LacpBaseTlv;

public class LacpBaseTlvTest {
    private static final String PACKET_DUMP = "baseinfo.bin";
    private byte[] data;
    private static final short SYS_PRIORITY = Short.MIN_VALUE;
    private static final MacAddress SYS_MAC = MacAddress.valueOf((String)"a4:23:05:00:11:22");
    private static final short KEY = 13;
    private static final short PORT_PRIORITY = Short.MIN_VALUE;
    private static final short PORT = 22;
    private static final byte STATE = -123;
    static final LacpBaseTlv BASE_TLV = new LacpBaseTlv().setSystemPriority((short)Short.MIN_VALUE).setSystemMac(SYS_MAC).setKey((short)13).setPortPriority((short)Short.MIN_VALUE).setPort((short)22).setState((byte)-123);

    @Before
    public void setUp() throws Exception {
        this.data = Resources.toByteArray((URL)LacpBaseTlvTest.class.getResource(PACKET_DUMP));
    }

    @Test
    public void deserializer() throws Exception {
        LacpBaseTlv actorInfo = (LacpBaseTlv)LacpBaseTlv.deserializer().deserialize(this.data, 0, this.data.length);
        Assert.assertEquals((long)-32768L, (long)actorInfo.getSystemPriority());
        Assert.assertEquals((Object)SYS_MAC, (Object)actorInfo.getSystemMac());
        Assert.assertEquals((long)13L, (long)actorInfo.getKey());
        Assert.assertEquals((long)-32768L, (long)actorInfo.getPortPriority());
        Assert.assertEquals((long)22L, (long)actorInfo.getPort());
        Assert.assertEquals((long)-123L, (long)actorInfo.getState().toByte());
    }

    @Test
    public void serialize() {
        Assert.assertArrayEquals((byte[])this.data, (byte[])BASE_TLV.serialize());
    }
}

