/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.onlab.packet.BasePacket;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Deserializer;
import org.onlab.packet.IPacket;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.lacp.Lacp;

public class Slow
extends BasePacket {
    public static final int HEADER_LENGTH = 1;
    public static final byte SUBTYPE_LACP = 1;
    public static final Map<Byte, Deserializer<? extends IPacket>> PROTOCOL_DESERIALIZER_MAP = ImmutableMap.builder().put((Object)1, Lacp.deserializer()).build();
    private byte subtype;

    public byte getSubtype() {
        return this.subtype;
    }

    public Slow setSubtype(byte subtype) {
        this.subtype = subtype;
        return this;
    }

    public static Deserializer<Slow> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 1);
            Slow slow = new Slow();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            slow.setSubtype(bb.get());
            if (!PROTOCOL_DESERIALIZER_MAP.containsKey(slow.subtype)) {
                throw new DeserializationException("Unsupported slow protocol subtype " + Byte.toString(slow.subtype));
            }
            Deserializer<? extends IPacket> deserializer = PROTOCOL_DESERIALIZER_MAP.get(slow.subtype);
            int remainingLength = bb.limit() - bb.position();
            slow.payload = deserializer.deserialize(data, bb.position(), remainingLength);
            slow.payload.setParent(slow);
            return slow;
        };
    }

    @Override
    public byte[] serialize() {
        int length = 1;
        byte[] payloadData = null;
        if (this.payload != null) {
            this.payload.setParent(this);
            payloadData = this.payload.serialize();
            length += payloadData.length;
        }
        byte[] data = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put(this.subtype);
        if (payloadData != null) {
            bb.put(payloadData);
        }
        return data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subtype);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Slow)) {
            return false;
        }
        Slow other = (Slow)obj;
        return this.subtype == other.subtype;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("subtype", (Object)Byte.toString(this.subtype)).toString();
    }
}

