/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.onlab.packet.Deserializer;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PacketUtils;
import org.onlab.packet.lacp.LacpState;
import org.onlab.packet.lacp.LacpTlv;

public class LacpBaseTlv
extends LacpTlv {
    public static final byte LENGTH = 20;
    private static final byte[] RESERVED = new byte[3];
    private short systemPriority;
    private MacAddress systemMac;
    private short key;
    private short portPriority;
    private short port;
    private LacpState state;

    public short getSystemPriority() {
        return this.systemPriority;
    }

    public LacpBaseTlv setSystemPriority(short systemPriority) {
        this.systemPriority = systemPriority;
        return this;
    }

    public MacAddress getSystemMac() {
        return this.systemMac;
    }

    public LacpBaseTlv setSystemMac(MacAddress systemMac) {
        this.systemMac = systemMac;
        return this;
    }

    public short getKey() {
        return this.key;
    }

    public LacpBaseTlv setKey(short key) {
        this.key = key;
        return this;
    }

    public short getPortPriority() {
        return this.portPriority;
    }

    public LacpBaseTlv setPortPriority(short portPriority) {
        this.portPriority = portPriority;
        return this;
    }

    public short getPort() {
        return this.port;
    }

    public LacpBaseTlv setPort(short port) {
        this.port = port;
        return this;
    }

    public LacpState getState() {
        return this.state;
    }

    public LacpBaseTlv setState(byte state) {
        this.state = new LacpState(state);
        return this;
    }

    public static Deserializer<LacpBaseTlv> deserializer() {
        return (data, offset, length) -> {
            PacketUtils.checkInput(data, offset, length, 18);
            LacpBaseTlv lacpBaseTlv = new LacpBaseTlv();
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            lacpBaseTlv.setSystemPriority(bb.getShort());
            byte[] mac = new byte[6];
            bb.get(mac);
            lacpBaseTlv.setSystemMac(MacAddress.valueOf(mac));
            lacpBaseTlv.setKey(bb.getShort());
            lacpBaseTlv.setPortPriority(bb.getShort());
            lacpBaseTlv.setPort(bb.getShort());
            lacpBaseTlv.setState(bb.get());
            return lacpBaseTlv;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[18];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putShort(this.systemPriority);
        bb.put(this.systemMac.toBytes());
        bb.putShort(this.key);
        bb.putShort(this.portPriority);
        bb.putShort(this.port);
        bb.put(this.state.toByte());
        bb.put(RESERVED);
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LacpBaseTlv)) {
            return false;
        }
        LacpBaseTlv other = (LacpBaseTlv)obj;
        return this.systemPriority == other.systemPriority && this.key == other.key && this.portPriority == other.portPriority && this.port == other.port && Objects.equals(this.state, other.state) && Objects.equals(this.systemMac, other.systemMac);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.systemPriority, this.systemMac, this.key, this.portPriority, this.port, this.state);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("systemPriority", (Object)Short.toString(this.systemPriority)).add("systemMac", (Object)this.systemMac.toString()).add("key", (Object)Short.toString(this.key)).add("portPriority", (Object)Short.toString(this.portPriority)).add("port", (Object)Short.toString(this.port)).add("state", (Object)this.state.toString()).toString();
    }
}

