/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.Deserializer;
import org.onlab.packet.LLC;
import org.onlab.packet.PacketTestUtils;

public class LLCTest {
    private Deserializer<LLC> deserializer;
    private byte dsap = (byte)10;
    private byte ssap = (byte)20;
    private byte ctrl = (byte)30;
    private byte[] bytes;

    @Before
    public void setUp() throws Exception {
        this.deserializer = LLC.deserializer();
        ByteBuffer bb = ByteBuffer.allocate(3);
        bb.put(this.dsap);
        bb.put(this.ssap);
        bb.put(this.ctrl);
        this.bytes = bb.array();
    }

    @Test
    public void testDeserializeBadInput() throws Exception {
        PacketTestUtils.testDeserializeBadInput(this.deserializer);
    }

    @Test
    public void testDeserializeTruncated() throws Exception {
        PacketTestUtils.testDeserializeTruncated(this.deserializer, this.bytes);
    }

    @Test
    public void testDeserialize() throws Exception {
        LLC llc = (LLC)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        Assert.assertEquals((long)this.dsap, (long)llc.getDsap());
        Assert.assertEquals((long)this.ssap, (long)llc.getSsap());
        Assert.assertEquals((long)this.ctrl, (long)llc.getCtrl());
    }

    @Test
    public void testToStringLLC() throws Exception {
        LLC llc = (LLC)this.deserializer.deserialize(this.bytes, 0, this.bytes.length);
        String str = llc.toString();
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("dsap=" + this.dsap)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("ssap=" + this.ssap)));
        Assert.assertTrue((boolean)StringUtils.contains((CharSequence)str, (CharSequence)("ctrl=" + this.ctrl)));
    }
}

