/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.onlab.packet.IpAddress;

public final class Ip4Address
extends IpAddress {
    public static final IpAddress.Version VERSION = IpAddress.Version.INET;
    public static final int BYTE_LENGTH = 4;
    public static final int BIT_LENGTH = 32;
    public static final Ip4Address ZERO = Ip4Address.valueOf("0.0.0.0");

    private Ip4Address(byte[] value) {
        super(VERSION, value);
    }

    public int toInt() {
        ByteBuffer bb = ByteBuffer.wrap(super.toOctets());
        return bb.getInt();
    }

    public static Ip4Address valueOf(int value) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
        return new Ip4Address(bytes);
    }

    public static Ip4Address valueOf(byte[] value) {
        return new Ip4Address(value);
    }

    public static Ip4Address valueOf(byte[] value, int offset) {
        IpAddress.checkArguments(VERSION, value, offset);
        byte[] bc = Arrays.copyOfRange(value, offset, value.length);
        return Ip4Address.valueOf(bc);
    }

    public static Ip4Address valueOf(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            return new Ip4Address(bytes);
        }
        if (inetAddress instanceof Inet6Address || bytes.length == 16) {
            String msg = "Invalid IPv4 version address string: " + inetAddress.toString();
            throw new IllegalArgumentException(msg);
        }
        if (bytes.length == 4) {
            return new Ip4Address(bytes);
        }
        String msg = "Unrecognized IP version address string: " + inetAddress.toString();
        throw new IllegalArgumentException(msg);
    }

    public static Ip4Address valueOf(String value) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddresses.forString((String)value);
        }
        catch (IllegalArgumentException e) {
            String msg = "Invalid IP address string: " + value;
            throw new IllegalArgumentException(msg);
        }
        return Ip4Address.valueOf(inetAddress);
    }

    public static Ip4Address makeMaskPrefix(int prefixLength) {
        byte[] mask = IpAddress.makeMaskPrefixArray(VERSION, prefixLength);
        return new Ip4Address(mask);
    }

    public static Ip4Address makeMaskedAddress(Ip4Address address, int prefixLength) {
        byte[] net = Ip4Address.makeMaskedAddressArray(address, prefixLength);
        return Ip4Address.valueOf(net);
    }
}

