/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.PPPoEDTag;
import org.onlab.packet.PacketUtils;

public class PPPoED
extends BasePacket {
    protected byte version;
    protected byte type;
    protected byte code;
    protected short sessionId;
    protected short payloadLength;
    protected List<PPPoEDTag> tags = new ArrayList<PPPoEDTag>();
    public static final byte PPPOED_CODE_PADI = 9;
    public static final byte PPPOED_CODE_PADO = 7;
    public static final byte PPPOED_CODE_PADR = 25;
    public static final byte PPPOED_CODE_PADS = 101;
    public static final byte PPPOED_CODE_PADT = -89;
    private static final int HEADER_LENGTH = 6;
    private static final int TAG_HEADER_LENGTH = 4;

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getCode() {
        return this.code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(short sessionId) {
        this.sessionId = sessionId;
    }

    public short getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(short payloadLength) {
        this.payloadLength = payloadLength;
    }

    public List<PPPoEDTag> getTags() {
        return this.tags;
    }

    public void setTags(List<PPPoEDTag> tags) {
        this.tags = tags;
    }

    public ArrayList<PPPoEDTag> getTagList(short tagType) {
        ArrayList<PPPoEDTag> tagList = new ArrayList<PPPoEDTag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i).getType() != tagType) continue;
            tagList.add(this.tags.get(i));
        }
        return tagList;
    }

    public PPPoEDTag getTag(short tagType) {
        for (int i = 0; i < this.tags.size(); ++i) {
            if (this.tags.get(i).getType() != tagType) continue;
            return this.tags.get(i);
        }
        return null;
    }

    public PPPoEDTag setTag(short tagType, byte[] value) {
        short tagLength = (short)value.length;
        PPPoEDTag newTag = new PPPoEDTag(tagType, tagLength, value);
        this.tags.add(newTag);
        this.payloadLength = (short)(this.payloadLength + (4 + tagLength));
        return newTag;
    }

    public static Deserializer<PPPoED> deserializer() {
        return (data, offset, length) -> {
            PPPoEDTag tag;
            PacketUtils.checkInput(data, offset, length, 6);
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            PPPoED pppoed = new PPPoED();
            byte versionByte = bb.get();
            pppoed.setVersion((byte)(versionByte >> 4 & 0xF));
            pppoed.setType((byte)(versionByte & 0xF));
            pppoed.setCode(bb.get());
            pppoed.setSessionId(bb.getShort());
            pppoed.setPayloadLength(bb.getShort());
            for (int remainingLength = pppoed.payloadLength; remainingLength > 0 && bb.hasRemaining(); remainingLength -= tag.length + 4) {
                tag = new PPPoEDTag();
                tag.setType(bb.getShort());
                tag.setLength(bb.getShort());
                tag.value = new byte[tag.length];
                bb.get(tag.value, 0, tag.length);
                pppoed.tags.add(tag);
            }
            return pppoed;
        };
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[this.payloadLength + 6];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.put((byte)((this.version & 0xF) << 4 | this.type & 0xF));
        bb.put(this.code);
        bb.putShort(this.sessionId);
        bb.putShort(this.payloadLength);
        for (int i = 0; i < this.tags.size(); ++i) {
            PPPoEDTag tag = this.tags.get(i);
            bb.putShort(tag.getType());
            bb.putShort(tag.getLength());
            bb.put(tag.getValue());
        }
        return data;
    }

    public String toString() {
        return "PPPoED{version=" + this.version + ", type=" + this.type + ", code=" + this.code + ", session_id=" + this.sessionId + ", payload_length=" + this.payloadLength + ", tags=" + this.tags + "}";
    }

    public static enum Type {
        PADI(9),
        PADO(7),
        PADR(25),
        PADS(101),
        PADT(-89);

        public int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type getTypeByValue(int value) {
            return Stream.of(Type.values()).filter(el -> el.value == value).findFirst().orElse(null);
        }
    }
}

