/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet.lacp;

import com.google.common.io.Resources;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.lacp.LacpCollectorTlv;

public class LacpCollectorTlvTest {
    private static final String PACKET_DUMP = "collectorinfo.bin";
    private byte[] data;
    private static final short COLLECTOR_MAX_DELAY = Short.MIN_VALUE;
    static final LacpCollectorTlv COLLECTOR_TLV = new LacpCollectorTlv().setCollectorMaxDelay((short)Short.MIN_VALUE);

    @Before
    public void setUp() throws Exception {
        this.data = Resources.toByteArray((URL)LacpCollectorTlvTest.class.getResource(PACKET_DUMP));
    }

    @Test
    public void deserializer() throws Exception {
        LacpCollectorTlv lacpCollectorTlv = (LacpCollectorTlv)LacpCollectorTlv.deserializer().deserialize(this.data, 0, this.data.length);
        Assert.assertEquals((long)-32768L, (long)lacpCollectorTlv.getCollectorMaxDelay());
    }

    @Test
    public void serialize() {
        Assert.assertArrayEquals((byte[])this.data, (byte[])COLLECTOR_TLV.serialize());
    }
}

