/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.util.ItemNotFoundException;
import org.onlab.util.Tools;

public class ToolsTest {
    @Test
    public void fromHex() throws Exception {
        Assert.assertEquals((long)15L, (long)Tools.fromHex((String)"0f"));
        Assert.assertEquals((long)16L, (long)Tools.fromHex((String)"10"));
        Assert.assertEquals((long)65535L, (long)Tools.fromHex((String)"ffff"));
        Assert.assertEquals((long)4096L, (long)Tools.fromHex((String)"1000"));
        Assert.assertEquals((long)-1L, (long)Tools.fromHex((String)"ffffffffffffffff"));
    }

    @Test
    public void toHex() throws Exception {
        Assert.assertEquals((Object)"0f", (Object)Tools.toHex((long)15L, (int)2));
        Assert.assertEquals((Object)"ffff", (Object)Tools.toHex((long)65535L, (int)4));
        Assert.assertEquals((Object)"1000", (Object)Tools.toHex((long)4096L, (int)4));
        Assert.assertEquals((Object)"000000000000000f", (Object)Tools.toHex((long)15L));
        Assert.assertEquals((Object)"ffffffffffffffff", (Object)Tools.toHex((long)-1L));
        Assert.assertEquals((Object)"0xffffffffffffffff", (Object)Tools.toHexWithPrefix((long)-1L));
    }

    @Test
    public void getBytesUtf8() {
        Assert.assertThat((Object)Tools.getBytesUtf8((String)"Hi!"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)new byte[]{72, 105, 33})));
    }

    @Test
    public void toStringUtf8() {
        Assert.assertThat((Object)Tools.toStringUtf8((byte[])new byte[]{72, 105, 33}), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Hi!")));
    }

    @Test
    public void copyOf() {
        byte[] input = new byte[]{1, 2, 3};
        Assert.assertThat((Object)Tools.copyOf((byte[])input), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)input)));
        Assert.assertNotSame((Object)input, (Object)Tools.copyOf((byte[])input));
    }

    @Test
    public void namedThreads() {
        ThreadFactory f = Tools.namedThreads((String)"foo-%d");
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertTrue((String)"wrong pattern", (boolean)t.getName().startsWith("foo-"));
    }

    @Test
    public void groupedThreads() {
        ThreadFactory f = Tools.groupedThreads((String)"foo/bar-me", (String)"foo-%d");
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertTrue((String)"wrong pattern", (boolean)t.getName().startsWith("foo-bar-me-foo-"));
        Assert.assertTrue((String)"wrong group", (boolean)"foo/bar-me".equals(t.getThreadGroup().getName()));
    }

    @Test
    public void minPriority() {
        ThreadFactory f = Tools.minPriority((ThreadFactory)Tools.namedThreads((String)"foo-%d"));
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertThat((Object)t.getPriority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void maxPriority() {
        ThreadFactory f = Tools.maxPriority((ThreadFactory)Tools.namedThreads((String)"foo-%d"));
        Thread t = f.newThread(() -> TestTools.print((String)"yo"));
        Assert.assertThat((Object)t.getPriority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)10)));
    }

    @Test
    public void exceptionHandler() throws InterruptedException {
        ThreadFactory f = Tools.namedThreads((String)"foo");
        Thread t = f.newThread(() -> {
            throw new IllegalStateException("BOOM!");
        });
        Assert.assertNotNull((String)"thread should have exception handler", (Object)t.getUncaughtExceptionHandler());
        t.start();
        TestTools.assertAfter((int)100, () -> Assert.assertEquals((String)"incorrect thread state", (Object)((Object)Thread.State.TERMINATED), (Object)((Object)t.getState())));
    }

    @Test
    public void testIsNullOrEmpty() {
        Assert.assertTrue((boolean)Tools.isNullOrEmpty(null));
        Assert.assertTrue((boolean)Tools.isNullOrEmpty(Collections.emptyList()));
    }

    @Test(expected=ItemNotFoundException.class)
    public void testNullIsNotFoundThrow() {
        Tools.nullIsNotFound(null, (String)"Not found!");
        Assert.fail((String)"Should've thrown some thing");
    }

    @Test
    public void testNullIsNotFound() {
        String input = "Foo";
        String output = (String)Tools.nullIsNotFound((Object)input, (String)"Not found!");
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertSame((Object)input, (Object)output);
    }

    @Test(expected=ItemNotFoundException.class)
    public void testEmptyIsNotFoundNullThrow() {
        Tools.emptyIsNotFound(null, (String)"Not found!");
        Assert.fail((String)"Should've thrown some thing");
    }

    @Test(expected=ItemNotFoundException.class)
    public void testEmptyIsNotFoundEmptyThrow() {
        Tools.emptyIsNotFound(Collections.emptySet(), (String)"Not found!");
        Assert.fail((String)"Should've thrown some thing");
    }

    @Test
    public void testEmptyIsNotFound() {
        ImmutableSet input = ImmutableSet.of((Object)"Foo", (Object)"Bar");
        Set output = Tools.emptyIsNotFound((Set)input, (String)"Not found!");
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertSame((Object)input, (Object)output);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIsIllegalThrow() {
        Tools.nullIsIllegal(null, (String)"Not found!");
        Assert.fail((String)"Should've thrown some thing");
    }

    @Test
    public void testNullIsIllegal() {
        String input = "Foo";
        String output = (String)Tools.nullIsIllegal((Object)input, (String)"Not found!");
        Assert.assertEquals((Object)input, (Object)output);
        Assert.assertSame((Object)input, (Object)output);
    }

    @Test
    public void testReadTreeFromStream() throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(Tools.getBytesUtf8((String)"{\"foo\" : \"bar\"}"));
        ObjectNode obj = Tools.readTreeFromStream((ObjectMapper)new ObjectMapper(), (InputStream)stream);
        Assert.assertTrue((boolean)obj.has("foo"));
        Assert.assertThat((Object)obj.get("foo").asText(), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void testDictonary() {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("foo", "bar");
        map.put("one", 1);
        map.put("empty", "");
        map.put("enabled", "true");
        map.put("Enabled", true);
        map.put("disabled", "disabled");
        map.put("Disabled", false);
        Dictionary dict = map;
        Assert.assertThat((Object)Tools.get((Dictionary)dict, (String)"foo"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bar")));
        Assert.assertThat((Object)Tools.get((Dictionary)dict, (String)"don't exist"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)Tools.get((Dictionary)dict, (String)"one"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"1")));
        Assert.assertThat((Object)Tools.get((Dictionary)dict, (String)"empty"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)Tools.getIntegerProperty((Dictionary)dict, (String)"one"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((Object)Tools.getIntegerProperty((Dictionary)dict, (String)"empty"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)Tools.getIntegerProperty((Dictionary)dict, (String)"foo"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)Tools.getIntegerProperty((Dictionary)dict, (String)"one", (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((Object)Tools.getIntegerProperty((Dictionary)dict, (String)"empty", (int)2), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"enabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.TRUE)));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"Enabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.TRUE)));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"disabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.FALSE)));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"Disabled"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Boolean.FALSE)));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"empty"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"enabled", (boolean)false), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"disabled", (boolean)true), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Tools.isPropertyEnabled((Dictionary)dict, (String)"empty", (boolean)false), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Tools.getLongProperty((Dictionary)dict, (String)"one"), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)Tools.getLongProperty((Dictionary)dict, (String)"foo"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testOptionalStream() {
        Stream empty = Tools.stream(Optional.empty());
        Assert.assertThat((Object)empty.count(), (Matcher)Matchers.is((Object)0L));
        String value = "value";
        Stream stream = Tools.stream(Optional.of(value));
        Assert.assertThat((Object)stream.allMatch(value::equals), (Matcher)Matchers.is((Object)true));
    }
}

