/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduParameterSet;

public class EAPOLMkpduDistributedSAKParameterSet
extends BasePacket
implements EAPOLMkpduParameterSet {
    private byte distributedAN;
    private byte confidentialityOffset;
    private int keyNumber;
    private byte[] sak;
    private short bodyLength;
    public static final short TOTAL_DSAKPS_BODY_LENGTH = 32;
    public static final short SAK_FIELD_LENGTH = 24;
    public static final byte DSAKPS_GENERAL_MASK = 3;
    public static final byte DISTRIBUTED_AN_OFFSET = 6;
    public static final byte CONFIDENTIALITY_OFFSET = 4;
    KeyWrapper sakWrapper;

    @Override
    public byte getParameterSetType() {
        return 4;
    }

    @Override
    public short getTotalLength() {
        return 32;
    }

    @Override
    public short getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(short bodyLength) {
        this.bodyLength = bodyLength;
    }

    @Override
    public byte[] serialize() {
        short length = this.getTotalLength();
        ByteBuffer data = ByteBuffer.wrap(new byte[length]);
        data.put((byte)4);
        byte octet = 0;
        octet = (byte)((3 & this.distributedAN) << 6);
        octet = (byte)(octet | (byte)((3 & this.confidentialityOffset) << 4));
        data.put(octet);
        length = (short)(length - 4);
        octet = (byte)(octet | (byte)(length >> 8 & 0xF));
        data.put(octet);
        data.put((byte)length);
        data.putInt(this.keyNumber);
        data.put(this.sakWrapper.wrap(this.sak));
        return data.array();
    }

    public static Deserializer<EAPOLMkpduDistributedSAKParameterSet> deserializer() {
        return (data, offset, length) -> {
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpduDistributedSAKParameterSet dps = new EAPOLMkpduDistributedSAKParameterSet();
            byte[] mbField = new byte[]{bb.get()};
            dps.setDistributedAN((byte)(mbField[0] >> 6 & 3));
            dps.setConfidentialityOffset((byte)(mbField[0] >> 4 & 3));
            mbField[0] = bb.get();
            short bodyLength = (short)((short)(mbField[0] & 0xF) << 8);
            bodyLength = (short)(bodyLength | (short)bb.get());
            dps.setBodyLength(bodyLength);
            dps.setKeyNumber(bb.getInt());
            mbField = new byte[24];
            bb.get(mbField, 0, 24);
            dps.setSAK(mbField);
            return dps;
        };
    }

    public void setDistributedAN(byte distributedAN) {
        this.distributedAN = distributedAN;
    }

    public void setConfidentialityOffset(byte confidentialityOffset) {
        this.confidentialityOffset = confidentialityOffset;
    }

    public void setKeyNumber(int keyNumber) {
        this.keyNumber = keyNumber;
    }

    public void setSAK(byte[] sak) {
        this.sak = sak;
    }

    public void setKeyWrapper(KeyWrapper sakWrapper) {
        this.sakWrapper = sakWrapper;
    }

    @FunctionalInterface
    public static interface KeyWrapper {
        public byte[] wrap(byte[] var1);
    }
}

