/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlString
implements CharSequence {
    private static final Logger log = LoggerFactory.getLogger(XmlString.class);
    private final Supplier<String> prettyString = Suppliers.memoize(() -> this.prettyPrintXml(inputXml));

    public static CharSequence prettifyXml(CharSequence xml) {
        return new XmlString(CharSource.wrap((CharSequence)xml));
    }

    XmlString(CharSource inputXml) {
    }

    private String prettyPrintXml(CharSource inputXml) {
        try {
            Document document;
            boolean wasFragment = false;
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docBuilder.setErrorHandler(new DefaultHandler());
            try {
                document = docBuilder.parse(new InputSource(inputXml.openStream()));
            }
            catch (SAXException e) {
                log.debug("will retry assuming input is XML fragment", (Throwable)e);
                try {
                    document = docBuilder.parse(new InputSource(CharSource.concat((CharSource[])new CharSource[]{CharSource.wrap((CharSequence)"<vroot>"), inputXml, CharSource.wrap((CharSequence)"</vroot>")}).openStream()));
                    wasFragment = true;
                }
                catch (SAXException e1) {
                    log.debug("SAXException after retry", (Throwable)e1);
                    throw e;
                }
            }
            document.normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "UTF-8");
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter strWriter = new StringWriter();
            if (wasFragment) {
                NodeList children = document.getDocumentElement().getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    t.transform(new DOMSource(children.item(i)), new StreamResult(strWriter));
                }
            } else {
                t.transform(new DOMSource(document), new StreamResult(strWriter));
            }
            return strWriter.toString();
        }
        catch (Exception e) {
            log.warn("Pretty printing failed", (Throwable)e);
            try {
                String rawInput = inputXml.read();
                log.debug("  failed input: \n{}", (Object)rawInput);
                return rawInput;
            }
            catch (IOException e1) {
                log.error("Failed to read from input", (Throwable)e1);
                return inputXml.toString();
            }
        }
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        return (String)this.prettyString.get();
    }
}

