/*
 * Decompiled with CFR 0.152.
 */
package org.onlab.packet;

import java.nio.ByteBuffer;
import org.onlab.packet.BasePacket;
import org.onlab.packet.Deserializer;
import org.onlab.packet.EAPOLMkpduParameterSet;

public class EAPOLMkpduMACSecUseParameterSet
extends BasePacket
implements EAPOLMkpduParameterSet {
    private boolean delayProtect = false;
    private boolean plainTX = false;
    private boolean plainRX = false;
    private byte[] latestKI;
    private int latestKN;
    private byte latestAN;
    private int latestLAPN;
    private boolean latestTX;
    private boolean latestRX;
    private byte[] oldKI;
    private int oldKN;
    private byte oldAN;
    private int oldLAPN;
    private boolean oldTX;
    private boolean oldRX;
    private short bodyLength;
    public static final short TOTAL_SUPS_BODY_LENGTH = 44;
    public static final short LATEST_KEY_AN_OFFSET = 6;
    public static final short OLD_KEY_AN_OFFSET = 2;
    public static final byte LATEST_KEY_RX_MASK = 16;
    public static final byte LATEST_KEY_TX_MASK = 32;
    public static final byte OLD_KEY_RX_MASK = 1;
    public static final byte OLD_KEY_TX_MASK = 2;
    public static final byte KEY_AN_MASK = 2;
    public static final byte PLAIN_TX_MASK = -128;
    public static final byte PLAIN_RX_MASK = 64;
    public static final byte DELAY_PROTECT_MASK = 16;
    public static final short SUPS_FIXED_PART_TOTAL_SIZE = 44;

    @Override
    public byte[] serialize() {
        short length = this.getTotalLength();
        ByteBuffer data = ByteBuffer.wrap(new byte[length]);
        data.put((byte)3);
        byte octet = 0;
        octet = (byte)(this.latestRX ? octet | 0x10 : octet & 0xFFFFFFEF);
        octet = (byte)(this.latestTX ? octet | 0x20 : octet & 0xFFFFFFDF);
        octet = (byte)(this.oldRX ? octet | 1 : octet & 0xFFFFFFFE);
        octet = (byte)(this.oldTX ? octet | 2 : octet & 0xFFFFFFFD);
        octet = (byte)(octet | this.latestAN << 6);
        octet = (byte)(octet | this.oldAN << 2);
        data.put(octet);
        octet = 0;
        octet = (byte)(this.plainTX ? octet | 0xFFFFFF80 : octet & 0x7F);
        octet = (byte)(this.plainRX ? octet | 0x40 : octet & 0xFFFFFFBF);
        octet = (byte)(this.delayProtect ? octet | 0x10 : octet & 0xFFFFFFEF);
        length = (short)(length - 4);
        octet = (byte)(octet | (byte)(length >> 8 & 0xF));
        data.put(octet);
        data.put((byte)length);
        data.put(this.latestKI);
        data.putInt(this.latestKN);
        data.putInt(this.latestLAPN);
        data.put(this.oldKI);
        data.putInt(this.oldKN);
        data.putInt(this.oldLAPN);
        return data.array();
    }

    public static Deserializer<EAPOLMkpduMACSecUseParameterSet> deserializer() {
        return (data, offset, length) -> {
            ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
            EAPOLMkpduMACSecUseParameterSet macSecUsePS = new EAPOLMkpduMACSecUseParameterSet();
            byte[] mbField = new byte[]{bb.get()};
            macSecUsePS.setOldRX((mbField[0] & 1) != 0);
            macSecUsePS.setOldTX((mbField[0] & 2) != 0);
            macSecUsePS.setLatestRX((mbField[0] & 1) != 0);
            macSecUsePS.setLatestTX((mbField[0] & 2) != 0);
            macSecUsePS.setLatestAN((byte)(mbField[0] >> 6 & 2));
            macSecUsePS.setOldAN((byte)(mbField[0] >> 2 & 2));
            mbField[0] = bb.get();
            macSecUsePS.setPlainRX((mbField[0] & 0x40) != 0);
            macSecUsePS.setPlainTX((mbField[0] & 0xFFFFFF80) != 0);
            macSecUsePS.setDelayProtect((mbField[0] & 0x10) != 0);
            short bodyLength = (short)((short)(mbField[0] & 0xF) << 8);
            bodyLength = (short)(bodyLength | (short)bb.get());
            macSecUsePS.setBodyLength(bodyLength);
            mbField = new byte[12];
            bb.get(mbField, 0, 12);
            macSecUsePS.setLatestKI(mbField);
            macSecUsePS.setLatestKN(bb.getInt());
            macSecUsePS.setLatestLAPN(bb.getInt());
            mbField = new byte[12];
            bb.get(mbField, 0, 12);
            macSecUsePS.setOldKI(mbField);
            macSecUsePS.setOldKN(bb.getInt());
            macSecUsePS.setOldLAPN(bb.getInt());
            return macSecUsePS;
        };
    }

    @Override
    public byte getParameterSetType() {
        return 3;
    }

    @Override
    public short getTotalLength() {
        return 44;
    }

    @Override
    public short getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(short bodyLength) {
        this.bodyLength = bodyLength;
    }

    public void setDelayProtect(boolean delayProtect) {
        this.delayProtect = delayProtect;
    }

    public void setPlainTX(boolean plainTX) {
        this.plainTX = plainTX;
    }

    public void setPlainRX(boolean plainRX) {
        this.plainRX = plainRX;
    }

    public void setLatestLAPN(int latestLAPN) {
        this.latestLAPN = latestLAPN;
    }

    public void setLatestAN(byte latestAN) {
        this.latestAN = latestAN;
    }

    public void setLatestKI(byte[] latestKI) {
        this.latestKI = latestKI;
    }

    public void setLatestKN(int latestKN) {
        this.latestKN = latestKN;
    }

    public void setLatestTX(boolean latestTX) {
        this.latestTX = latestTX;
    }

    public void setLatestRX(boolean latestRX) {
        this.latestRX = latestRX;
    }

    public void setOldLAPN(int oldLAPN) {
        this.oldLAPN = oldLAPN;
    }

    public void setOldAN(byte oldAN) {
        this.oldAN = oldAN;
    }

    public void setOldKI(byte[] oldKI) {
        this.oldKI = oldKI;
    }

    public void setOldKN(int oldKN) {
        this.oldKN = oldKN;
    }

    public void setOldTX(boolean oldTX) {
        this.oldTX = oldTX;
    }

    public void setOldRX(boolean oldRX) {
        this.oldRX = oldRX;
    }
}

